'==============================================================================
'=  Runner AT32-Platine mit vollstndiger Steuerung
'=  PWM-Ausgang ist OC1A =PortD.5
'=  PWM-Ausgang ist OC1B =PortD.4
'=
'=
'= V6.0.0   Wie V5.6.3e fr die neuen Platinen
'= V6.0.1   Power-Relais schaltet beim Erreichen von 33Volt ein.
'= V6.0.2+  Prfung der Kondensatorspannung vor dem Einschalten des Relais
'=
'=          Prfung der Sensor-Ruhewerte beim Start, ggf. neu einstellen
'= V6.0.3   Einbau der Strommessung mit ADC7, Anzeige mit groen Display
'= V6.0.4   Messung der verbrauchten Batteriekapazitt mit Rest-Anzeige (Ah)
'=          !! Geschwindigkeitsanzeige ab 8km/h falsch !!!
'= V6.0.4.3 Runner_typ wird aktiv verwendet
'=          Get_Phi_rate() eingefgt fr Runner 1,2 und 3
'= V6.1.0   bernahme von V6.0.4.3 fr Atmega324APU mit 20MHz
'=          $crystal, Way_count-Adresse und Timer2 angepasst
'=
'= V6.1.0.1 Messung der IRQ-Zeit ber PC6 und PC7
'= V6.1.1   Weg- und Geschwindigkeitsmessung wieder in der LCD-Ausgabeschleife
'=          Strom- und Ah-Auswertung in der LCD-Ausgabeschleife
'= V6.1.2   Erweiterte Erkennung der Sensorposition eingefgt
'=          Kennzeichnung von Programmblcken
'= V6.1.3   Anordnung im Display gendert, so dass I und Q im 24-stelligen
'=          Display rechts und andere Werte normal im 16-stelligen normal stehen.
'= V6.1.4   Reihenfolge der ERAM-Variablen und Sensorinitialisierung gendert
'=          PINC.6 zur Erkennung von Runner3 mit einer Brcke ->Gnd
'=          Geschwindigkeitsbegrenzung im Test (nicht aktiviert)
'=          Dynamische Beschleunigung im Test, Version fr Rainer Schwab
'= V6.2     ab 24.4.2013 - Numerierungen nur mit einer Dezimalstelle  !!!!
'=          Versuchsweiser Einbau des alten Gyrsensors aus Runner1 fr "Runner22"
'= V6.21    Test mit A_0 = 0.75 : B = 0.75
'= V6.22    A = 0.4 : B = 0.5 : C = 20 : Pwm_faktor_max = 350 : Filterfaktor = 10
'=          Gier_faktor=-4 , dynamische Beschleunigung verbessert,
'=          Version auch fr Runner3

'= V6.23    Filterfaktoren einzeln als Parameter einstellbar
'= V6.24    Sensorposition 1 reaktiviert (Fr Runner4)
'=          ** Speedlimit not available **
'= V6.30    Speichern alle Parameter und Faktoren im EERAM
'= V6.31    Eingabe mit PS/2 Keyboard
'= V6.33    Complete with keyboard inputs
'= V6.34    bugs fixed
'= V6.36    Externe "My_Parameters.bas"
'= V6.37    Text output changed in the "Renew" sub, watchdog with Auto_restart
'= V6.38    some small changes , Fixed Peukert fault
'= V6.39    dynamic balance for Parameter B added
'= V6.40    dynamic balance for Parameter A and B with new calculation /
'=          Ref_speed starts with 20 in My_Parameters
'= V6.41    Change Reset parameters, Display_mode=8 fr Manuel
'= V6.42    Change Sub Calculate_cs to Calculate_cs(store) ==> to EERAM
'===============================================================================

'*******************************************************************************
'01 ************** Dimensionierung von Variablen ******************************
'*******************************************************************************

$hwstack = 128                               '73
$framesize = 128                             '92
$swstack = 128                               '7
$lib "stackcheck.lib"
'Runner_typ = 0                              'Desk top PCB
'Runner_typ = 1                              'out of use
'Runner_typ = 2                              'mein Runner2
'Runner_typ = 22                             'Mein Runner2 mir altem Gyrosensor
'Runner_typ = 3                              'Frnkischer Runner3
'Runner_typ = 4                              'Manuel
'Runner_typ = 5                              'Jannik

'fr Runner_typ = 0
'$regfile = "m324PAdef.dat"                  'fr Mega324 mit ID 1E9511
'$crystal = 16000000

'fr Runner_typ = 2 or Runner_typ=22
'$regfile = "m324PAdef.dat"                   'fr Mega324 mit ID 1E9511
'$crystal = 20000000

'fr Runner_typ = 3 or Runner_typ = 4
$regfile = "m32def.dat "                     'fr Mega32 mit ID 1E9515 Rainer Schwab , Manuel
$crystal = 16000000                          'ggf. Quarzangabe nur 12MHz, reduziert interne Waits bei LCD-Ausgabe


'----------------- Variable fr Assembler-Interrupt Wegmessung -----------------

Dim Way_count As Dword At $100               'Wegzhler, siehe auch im Assemblerteil
Dim Way_count_temp As Dword                  'zum Zwischenspeichern
Dim Way_count_alt As Dword , Way_count_alt_2 As Dword , Way_count_diff As Dword
Dim Loop_count As Byte                       'LCD-Ausgabe bei neuen Daten signalisieren
Dim Runner_typ As Byte

'-------------------------------------------------------------------------------
Dim Pwm_word_r As Word , Pwm_word_l As Word 'PWM-Werte als Word
Dim Motor_pwm_r As Single , Motor_pwm_l As Single'PWM-Werte als Single
Dim Dt As Single
Dim Help As Single , Help_phi As Single'used in 10ms interrupt and Getphi()
Dim Temp As Single      'temp variable in Displayroutine

Dim Adc0 As Word , Adc1 As Word , Adc2 As Word , Adc3 As Word
Dim Adc4 As Word , Adc5 As Word , Adc6 As Word , Adc7 As Word , Adc7_temp As Word
Dim Phi As Single , Phi_0 As Single    'vertical tilt
Dim Phi_rate As Single , Brems_phi As Single

Dim A As Single , B As Single , C As Single , Phi_degree As Single
Dim I As Word , Run As Byte , D_run As Byte , Run_alt As Byte , Display_mode As Byte

Dim Lenkung As Single , Lenkung_alt As Single , Lenkung_0 As Word , Phi_rate_0 As Single
Dim Gier_0 As Single , Gier As Single , Sensor_position As Byte
Dim Lenk_faktor As Single , Gier_faktor As Single , Gier_alt As Single

Dim Beschleunigung As Single , Speed As Single , V_max As Single
Dim Pwm As Single , Pwm_alt As Single , Pwm_faktor As Single , Pwm_faktor_max As Single
Dim Timeout As Word , U_batt_faktor As Single , Speed_faktor As Single
Dim Key As Byte , Testps2 As Byte
Dim Op_0 As Word , Error As Byte , Pwm_max As Single , J As Byte , Timer2_load As Byte

Dim Km_speed As Single , Km_speed_max As Single , Trip As Single , Trip_faktor As Single
Dim U_batt As Single , U_min As Single , Display_count As Byte , Trip_all As Single , Z As String * 10
Dim W As Word , Run_count As Byte , Strom_wert As Single , Batterie_kap As Single
Dim Ref_speed_a As Single , Ref_speed_b As Single , U_min1 As Single , Int0_way As Single

Dim Filter_phi As Single , Filter_phi_rate As Single , Filter_gier As Single , Filter_lenkung As Single
Dim Phi_rate_alt As Single , Phi_alt As Single

Dim Overspeed As Single , Overspeed_integral As Single

Dim F As Single , T1 As Single , Tondauer As Word , Pulsdauer As Word 'Frequenz

Dim Check_summe As Single , V_str As String * 20

'--------------------------- Variable im EERAM ---------------------------------

Dim Dummy As Eram Word , Way_count_e As Eram Dword , Lenkung_0_e As Eram Word ,
Dim Phi_rate_0_e As Eram Single , Gier_0_e As Eram Single , Batterie_kap_e As Eram Single
Dim Phi_0_e As Eram Single , Error_e As Eram Byte

Dim Ref_speed_a_e As Eram Single , Ref_speed_b_e As Eram Single , Int0_way_e As Eram Single , Lenk_faktor_e As Eram Single
Dim Gier_faktor_e As Eram Single , U_batt_faktor_e As Eram Single , Display_mode_e As Eram Byte
Dim A_e As Eram Single , B_e As Eram Single , C_e As Eram Single , Filter_phi_e As Eram Single
Dim Filter_phi_rate_e As Eram Single , Filter_gier_e As Eram Single , U_min1_e As Eram Single
Dim Filter_lenkung_e As Eram Single , Pwm_max_e As Eram Single , Runner_typ_e As Eram Byte
Dim Pwm_faktor_max_e As Eram Single , Check_summe_e As Eram Single , Auto_restart_e As Eram Byte

$hwcheck                'stack check erst nach DIM aktivieren,
$framecheck             'da sonst $100 belegt wird
$softcheck

'*******************************************************************************
'02 ************** Declarationen und Konfigirationen (Sub, I/O) ***************
'*******************************************************************************

Declare Sub Init_sensors
Declare Sub Beep(byval Cn As Byte)           'Cn kurze Beeps
Declare Sub Musik
Declare Sub Menue
Declare Sub Update_parameters
Declare Sub Calculate_cs(byval Store As Byte)       'Calculate Check_summe and write to ERAM
Declare Sub Getkey                           'Getkey liefert den ASCII-Code der Taste
Declare Sub Renew(byref V_val As Single)
Declare Sub Auto_restart                     'No musik, no waits
Declare Sub Restore_parameters

Declare Function Get_gier() As Single
Declare Function Get_phi_rate() As Single
Declare Function Get_phi() As Single
Declare Function Simple_filter(byval Wa As Single , Byval Wf As Single , Byval Af As Single) As Single

Power_relais Alias Portc.0 : Config Power_relais = Output : Power_relais = 0 'an Transistor fr Relais
Run_switch Alias Pinc.1 : Config Run_switch = Input : Portc.1 = 1 'Pullup aktiviert fr Fuschalter
Irq_led_pin Alias Portc.2 : Config Irq_led_pin = Output       'LED auf Platine zeigt aktiven IRQ an
Neigung_led Alias Portc.3 : Config Neigung_led = Output       'Kontrollpin Neigung in Ruhestellung
Lenkung_led Alias Portc.4 : Config Lenkung_led = Output       'Kontrollpin Lenkung in Ruhestellung
Beep_pin Alias Portc.5 : Config Beep_pin = Output       'Ausgang fr Pieper
Runner3_pin Alias Pinc.6 : Config Runner3_pin = Input : Portc.6 = 1 'mit Pullup zur Erkennung von Runner3
Lcd_out_pin Alias Portc.7 : Config Lcd_out_pin = Output       'Kontrollpin fr Rechenroutine

Pwm_dir_l Alias Portd.6 : Config Pwm_dir_l = Output
Pwm_dir_r Alias Portd.7 : Config Pwm_dir_r = Output
Config Portd.4 = Output                      'Fr Atmega324 erforderlich
Config Portd.5 = Output                      'Fr Atmega324 erforderlich

Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portb.5 , Rs = Portb.4
Config Lcd = 16x2                            'muss sein fr BASCOM-Ausgaben mit 16 Zeichen und 2 Zeilen
Config Lcdbus = 4

Config Int0 = Falling
On Int0 Incr_way_count Nosave
Enable Int0

'----------------- Timer1 als PWM-Timer konfigurieren --------------------------
Config Timer1 = Pwm , Pwm = 9 , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down , Prescale = 1

'----------------- Timer2 als Zeitbasis erzeugt Interrupt alle 10ms ------------
Config Timer2 = Timer , Prescale = 1024
On Timer2 Calculate_balance Saveall
'Enable Timer2   'wird weiter unten eingeschaltet

'----------------- AD-Wandler konfigurieren Uref=Vcc=5Volt ---------------------
Config Adc = Single , Prescaler = Auto , Reference = Avcc : Start Adc

'----------------- Config PS/2 keyboard ----------------------------------------
Config Keyboard = Pind.0 , Data = Pind.1 , Keydata = Tabelle
Portd.0 = 1 : Portd.1 = 1                    'Pullup aktivieren

'*******************************************************************************
'03 ************** Initialisierungen ******************************************
'*******************************************************************************

Const V_ersion = "6.42"                      'Software version

Cls

Lcd "* Version " ; V_ersion ; " *"
Locate 2 , 1 : Lcd "****************"

If _xtal = 20000000 Then'Runner2 (22) only
   Timer2_load = 61                          'Timer2 counting 61 up to 256 for 10ms Interrupt
Else
   Timer2_load = 100                         'Timer2 counting 100 up to 256 for 10ms Interrupt
End If

Timer2 = Timer2_load                         'Timer2 prepare

'3a---------------- Fuschaltertest beim Start ausfhren -----------------

If Run_switch = 0 Then                       'Wenn der Fuschalter beim Einschalten gedrckt ist,
   Error_e = 99                              'wird ein scheinbarer Fehler markiert, um einen Neustart
   Cls                                       'mit Neueinstellung der Sensorwerte auszulsen.
   'Wenn beim Start ein Fuschalter klemmt oder
   'gedrckt wird, erscheint ebenfalls diese Fehlermeldung.
   Lcd "***  ERROR=" ; Error ; " ***"
   Locate 2 , 1
   Lcd "  Please restart !"
End If

If Auto_restart_e = 0 Then                   'normal start
   Call Musik                                'Power_Up fr Kondensatoren und OP abwarten
Else
   Power_relais = 1                          'no music and instant switch on
   Auto_restart_e = 0
End If

'3b------------------ Read offset values form ERAM -----------------------------

Lenkung_0 = Lenkung_0_e                      'aus dem EERAM auslesen
Phi_0 = Phi_0_e                              'aus dem EERAM auslesen
Phi_rate_0 = Phi_rate_0_e                    'aus dem EERAM auslesen
Gier_0 = Gier_0_e                            'aus dem EERAM auslesen
Way_count = Way_count_e                      'aus dem EERAM auslesen
Batterie_kap = Batterie_kap_e                'aus dem EERAM auslesen

'3b1------------ Read parameter from EERAM and calculate checksumme ------------

Call Calculate_cs(0)                         'Read Parameters and calcilate, no strore

Help = Check_summe_e                         'Read check_summe from ERAM

'3b2--------------- Compare Check_summe with previous Check_summe --------------
'Check_summe error occures using a new controler without parameters

If Check_summe <> Help Then                  'preset parameters and recalculate Checksumme
   Cls
   Lcd "*Check_summ Error*"
   Locate 2 , 1
   Lcd "Restore Parameters"
   Call Beep(10)

   '===== All safe parameters are found into the "My_Parameters.bas" file ======
   '== available in the same folder and can be used in all following updates ===

   Call Restore_parameters                   '... from My_Parameters.bas

   Call Calculate_cs(1)                      'Read Parameters from ERAM and calculate and store check_summe

   '============================================================================
   Cls : Lcd "*Restart Runner*"
   Call Auto_restart                         'No musik, no waits

End If

'---------------- Show Start Screen --------------------------------------------
Cls

Lcd "* Runner_Typ=" ; Runner_typ ; " *"
Locate 2 , 1 : Lcd "****************"

Wait 1

'---------------- End Show Start Screen ----------------------------------------

Dt = 0.01                                    'feste Zeitdifferenz zwischen 2 Messungen (10ms)
Phi_alt = 0
Pwm_alt = 0
Brems_phi = 0                                'fr sptere Geschwindigkeitsbegrenzung
Lenkung_alt = 0
Phi_rate_alt = 0                             'wird fr Simple-Filter bentigt

U_min = 40                                   'Wird spter auf minimal auftretende Spannung reduziert
Trip_faktor = Int0_way / 100000
Speed_faktor = Trip_faktor * 3600
Way_count_alt = Way_count    'fr Geschwindigkeitsmessungen
Way_count_alt_2 = Way_count  'fr Tagesstrecke merken

Timeout = 0                                  'Zeitzhler fr Timeout

'3c---------------- Kondensatoren ausreichend geladen? -------------------------

Do
   Adc0 = Getadc(0)                          'Batteriespannung messen und warten
   U_batt = Adc0 * U_batt_faktor
   Locate 2 , 1 : Lcd "Batt:" ; U_batt ; "    "
   Waitms 200
   Incr Timeout                              '5 x pro Sekunde erhhen

   If Timeout > 50 Then                      'nach 10s Fehlermeldung auf das Display
      Cls
      Lcd "Batterie empty!"
      Locate 2 , 1
      Lcd "Charge Battery"
      Call Beep(10)                          '10 x piepen
   End If

Loop Until U_batt > U_min1                   '22/33 Volt erreicht

Power_relais = 1                             'Relais einschalten

Call Beep(1)

'3d------------------ Test foot switches 4 times and ---------------------------
'--------------- search PS/2 keyboard for parameter update ---------------------

Cls
Lcd "Press foot switch"

Locate 2 , 1
Lcd " or keyboard key "

For J = 1 To 4                               'test 4 switches
   I = 0
   Do
      If Run_switch = 0 Then
         Incr I                              'Zeitzhler fr Bettigungsdauer in ms
         Timeout = 0
      Else
         Incr Timeout                        'kein Fuschalter gedrckt
         I = 0
         Testps2 = Pind And 3                'Look for a keyboard at Port D
         If Testps2 < 3 Then                 'keyboard found
            Cls
            Lcd "Keyboard found"
            Call Beep(1)
            Wait 1
            Call Update_parameters           'goto update parameters
         End If
      End If

      Waitms 1

      If Timeout > 60000 Then                'Run_switch not pressed for 1 min
         Power_relais = 0                    'switch power off
      End If
   Loop Until I > 200                        'Run_switch pressed more than 200ms
   Locate 2 , 2
   Lcd "No.: " ; J ; "ok "

   Call Beep(1)

   Do : Loop Until Run_switch = 1            'Wait until Run_switch is open (off)

Next J

'3e------------------ Find out ADXL ... (Acc) Position -------------------------

Adc1 = Getadc(1)
Adc2 = Getadc(2)

'Sensor_position = 1  ==> ADXL Anschlsse oben (auf Hauptplatine)
'Sensor_position = 2  ==> ADXL Anschlsse unten, auch Runner2

Op_0 = 512                                   'Medium value of ADC1 and ADC2

Sensor_position = 0

If Adc1 > Op_0 And Adc2 > Op_0 Then          'Punkt am ADXL oben
   If Runner_typ = 3 Or Runner_typ = 0 Then
      Sensor_position = 1                    'alles ok
   End If
End If

If Adc1 < Op_0 And Adc2 < Op_0 Then          'Punkt am ADXL unten
   If Runner_typ = 2 Or Runner_typ = 22 Or Runner_typ = 4 Then
      Sensor_position = 2                    'alles ok
   End If
End If

If Sensor_position = 0 Then                  'No correct sensor found
   Lcd "!!Sensorerror!!"
   Call Beep(10)
   Power_relais = 0                          'Relais ausschalten
   Do : Loop                                 'Power down abwarten
End If


Cls

'3f------------------ Prfung und Erneuern Sensor-Ruhewerte --------------------

'Falls beim letzten Einschalten ein Fehler vorlag, ist Error_e > 0

Error = Error_e                              'read last Error from EERAM

If Error > 0 Then                            'Fehler, Sensor-Ruhewerte neu einlesen
   Cls
   Lcd "***  ERROR=" ; Error ; " ***"
   Call Beep(6)
   Cls
   Lcd "*Ruhewerte neu!*"
   Call Beep(1)
   Locate 2 , 1
   Lcd "-Ruhig stellen-"
   Call Beep(1)
   Wait 1
   Cls
   Lcd "*Press Button*"
   Do : Loop Until Run_switch = 0
   Call Beep(1)
   Do : Loop Until Run_switch = 1            'Warten bis Knopf losgelassen
   Call Beep(1)
   Wait 2

   Call Init_sensors                         'neue Ruhewerte einlesen

   Error_e = 0                               'Delete error number

   Locate 2 , 1
   Power_relais = 0                          'Relais ausschalten
   Cls : Lcd "*Restart Runner*"
   Call Beep(3)
   Wait 1
   Do : Loop
End If


'*******************************************************************************
'04 ************** Check all Sensor Offsets ************************************
'*******************************************************************************

'------------------ Prfung der Sensorwerte ------------------------------------
Waitms 100                                   'Warten - prfen, ob senkrechter Stand am Anfang
Phi = Get_phi()                              'Winkel=Abweichung von der Ruhelage feststellen
If Phi < -0.2 Or Phi > 0.2 Then
   Error = 1                                 'Anfangsneigung im unzulssigen Bereich 0  11.5
End If
'------------------ Prfen der Lenkungstellung ---------------------------------
Adc5 = Getadc(5)                             'Lenkungswert einlesen
Lenkung = Adc5 - Lenkung_0                   'Ruhewert subtrahieren
If Lenkung < -30 Or Lenkung > 30 Then
   Error = Error + 2
End If
'------------------ Prfen des Gyrosensors -------------------------------------
Phi_rate = Get_phi_rate()                    'Phi_rate
If Phi_rate < -20 Or Phi_rate > 20 Then
   Error = Error + 4
End If
'------------------ Prfen des Giersensors -------------------------------------
Gier = Get_gier()
If Gier < -20 Or Gier > 20 Then
   Error = Error + 8
End If

Error_e = Error                              'Fehler im EERAM speichern

If Error < 2 Then                            'Error=1 nur Neigungsfehler beim Einschalten oder Error=0
   Do                                        'Warten - prfen, ob senkrechter Stand am Anfang
      Phi = Get_phi()                        'Winkel=Abweichung von der Ruhelage feststellen
      Waitms 100
      Call Beep(1)
   Loop Until Phi > -0.2 And Phi < 0.2       'Anfangsneigung im zulssigen Bereich 0  11.5
   Error = 0
   Error_e = Error                           'Fehler lschen, alles ok
   Enable Interrupts
Else
   Call Beep(6)
   Cls
   Lcd "Sensorfehler:" ; Error

   Locate 2 , 1
   Lcd "*Restart Runner*"
   Power_relais = 0                          'Relais ausschalten
   Call Beep(3)
   Wait 5
   Do : Loop
End If

'--------------------------- Grundeinstellungen fertig -------------------------


'*******************************************************************************
'06 ************** Hauptschleife fr LCD-Ausgabe ******************************
'*******************************************************************************

'-------------------- Ausgabemodi fr LCD --------------------------------------

'  Display_mode = 0 'keine LCD-Ausgabe
'  Display_mode = 1 'Ausgabe der Sensorwerte
'  Display_mode = 2 'Ausgabe der PWMwerte
'  Display_mode = 3 'Normal-Ausgabe im Betrieb (vorbesetzt=
'  Display_mode = 4 'wie Case 3: mit Kontrollausgabe des Neigungswinkels
'  Display_mode = 5 'Ausgabe von Overspeed
'  Display_mode = 6 'Ausgabe der Stack-Werte
'  Display_mode = 7 'Ausgabe mit Stromstrke auf 24x2 LCD
'  Display_mode = 8 'Manuels Display

Cls

Adc0 = Getadc(0)                             'Batteriespannung messen, Ladezustand prfen
U_batt = Adc0 * U_batt_faktor

If U_batt > 40 Then
   Batterie_kap = 14                         'Batterie als neu geladen erkannt
   Batterie_kap_e = Batterie_kap             'Ladungszustand der Batterie speichern
End If

Display_count = 0                            'Togglebyte fr wechselnde Spannungs-/Stromanzeige
Loop_count = 80                              'vorbesetzt, damit die LCD-Ausgabe schnell erscheint

Enable Timer2                                'start 10ms interrupt

Do                                           'Hauptschleife und LCD-Ausgabe
   If Loop_count = 100 Then                  'Lcd -ausgabe Nach Jeder Sekunde Bei Loop_count = 100

      Lcd_out_pin = 1                        'PortC.7 fr Oszillograph
      Loop_count = 0                         'Zhler fr Sekundentakt zurcksetzen

      'Stromwerte zwischenspeichern, Getadc(7) wird im Interrupt ausgelesen
      Adc7_temp = Adc7 / 100                 'Mittelwert in einer Sekunde aus der Interruptroutine
      Adc7 = 0                               'Stromsumme zurcksetzen

      Adc0 = Getadc(0)                       'ADC0 fr sptere Displayausgabe auslesen

      'Way_Count fr Geschwindigkeit zwischenspeichern
      Way_count_temp = Way_count             'Wegzhler auslesen

      'calculating speed (km/h)
      Way_count_diff = Way_count_temp - Way_count_alt       'Differenz pro Sekunde
      Way_count_alt = Way_count_temp         'zur Geschwindigkeitsbestimmung

      Km_speed = Way_count_diff              'Convert DWord->single
      Km_speed = Km_speed * Speed_faktor

      If Km_speed > Km_speed_max Then
         Km_speed_max = Km_speed             'remember maximum speed
      End If

      Overspeed = Km_speed - V_max           'disabled at the moment, Differenz zur Max-Geschwindigkeit feststellen

      Select Case Display_mode

         Case 1:        'Kontrollausgaben

            Adc1 = Getadc(1)
            Adc2 = Getadc(2)

            Lcd "X" ; Adc1
            Locate 1 , 7 : Lcd "Y" ; Adc2

            'Phi = Get_phi()

            Locate 1 , 12 : Lcd "P" ; Phi
            Locate 2 , 1 : Lcd "G" ; Gier
            Locate 2 , 6 : Lcd " A" ; Adc3
            Locate 2 , 12 : Lcd "L" ; Adc5 ; " "

         Case 2:        'Kontrollausgaben

            Lcd "PWM=" ; Pwm ; "   L=" ; Lenkung
            Locate 2 , 1 : Lcd "L=" ; Motor_pwm_l ; "   ";
            Locate 2 , 9 : Lcd "R=" ; Motor_pwm_r ; "   ";

         Case 3:                             'Normalbetrieb mit Geschw. und Weganzeige

            'Ausgabe der Geschwindigkeit

            Z = Fusing(km_speed , "##.##")  '* 12.3km/h  18.1*
            Locate 1 , 1 : Lcd "* " ; Z ; "km/h "

            Z = Fusing(km_speed_max , "##.##")
            Lcd Z ; "*"

            'Ausgabe der Batteriespannung
            U_batt = Adc0 * U_batt_faktor
            If U_batt < U_min Then
               U_min = U_batt
            End If

            'Ausgabe der Mindestspannung
            If Display_count = 1 Then
               U_batt = U_min                'Es wird im Wechsel U_batt und U_min ausgegeben
            End If

            Z = Fusing(u_batt , "##.#")
            Locate 2 , 1 : Lcd Z ; "V "

            'Ausgabe der Wegstrecke
            If Run = 1 Then                  'Tages-Wegstrecke ausgeben
               Way_count_diff = Way_count_temp - Way_count_alt_2
               Trip = Way_count_diff         'Typkonvertierung
               Trip = Trip * Trip_faktor     'in km
               Z = Fusing(trip , "###.###")  'Tagesstrecke
            Else        'Gesamtstrecke ausgeben
               Trip_all = Way_count_temp     'single <== Dword
               Trip_all = Trip_all * Trip_faktor
               Z = Fusing(trip_all , "###.###")
            End If
            Locate 2 , 8 : Lcd Z ; "km"

            Incr Display_count
            If Display_count = 2 Then
               Display_count = 0             'Zurcksetzen
            End If

         Case 4:                             'Kontrollausgabe des Neigungswinkels

            Phi_degree = Phi * 57.325        'Umrechnung in Grad
            Z = Fusing(phi_degree , "##.##")
            Locate 2 , 1 : Lcd "P=" ; Z ; "  "       'Ausgabe des Neigungswinkels zur Kontrolle bei hheren Geschwindigkeiten

            Phi_degree = Phi_rate * 57.325   'Umrechnung in Grad
            Z = Fusing(phi_degree , "##.##")
            Locate 2 , 8 : Lcd "R=" ; Z      'Ausgabe des Neigungswinkels zur Kontrolle bei hheren Geschwindigkeiten

         Case 5:                             'Kontrollaugabe der Geschwindigkeitsbegrenzung

            Z = Fusing(km_speed , "##.##")   '* 12.3km/h  18.1*
            Locate 1 , 1 : Lcd "* " ; Z ; "km/h "

            Z = Fusing(km_speed_max , "##.##")
            Lcd Z ; "*"

            Locate 2 , 1
            Z = Fusing(overspeed , "##.##")
            Lcd Z ;
            Locate 2 , 8
            Z = Fusing(overspeed_integral , "##.##")
            Lcd Z ;

         Case 6:        'Ausgabe der Stack-Werte

            Lcd "* Stack-Werte *"
            W = _hwstackstart - _hw_lowest
            Locate 2 , 1 : Lcd "HW" ; W

            If _fw_highest > 0 Then
               W = _frame_high - _fw_highest
               Lcd " Fr" ; W
            End If

            W = _hwstack_low - _sw_lowest
            Lcd " S" ; W

         Case 7:

            Z = Fusing(km_speed , "##.##")
            Locate 1 , 1 : Lcd Z ; "km/h   "

            Z = Fusing(km_speed_max , "##.##")
            Locate 1 , 10 : Lcd Z ; "   "

            'Ausgabe der Wegstrecke
            If Run = 1 Then                  'Tages-Wegstrecke ausgeben
               Way_count_diff = Way_count_temp - Way_count_alt_2
               Trip = Way_count_diff         'Typkonvertierung
            Else
               Trip = Way_count_temp         'single <== Dword
            End If

            Trip = Trip * Trip_faktor        'Trip_faktor  '=0.0000224074
            Z = Fusing(trip , "###.###")
            'Locate 1 , 17 : Lcd Z ; "km   "
            Locate 2 , 9 : Lcd Z ; "km   "

            'Ausgabe der Batteriespannung
            U_batt = Adc0 * U_batt_faktor
            If U_batt < U_min Then
               U_min = U_batt
            End If

            'Ausgabe der Mindestspannung
            Incr Display_count
            If Display_count = 2 Then
               Display_count = 0             'Zurcksetzen
            End If

            If Display_count = 1 Then
               U_batt = U_min                'Es wird im Wechsel U_batt und U_min ausgegeben
            End If

            Z = Fusing(u_batt , "##.#")
            Locate 2 , 1 : Lcd Z ; "V   "

            'Ausgabe der Stromstrke
            Strom_wert = Adc7_temp - 121     'Offset subtrahieren
            Strom_wert = Strom_wert / 12.276 'Stromstrke berechnen
            Z = Fusing(strom_wert , "##.#")  'Mittelwert aus der letzten Sekunde
            Locate 1 , 18 : Lcd Z ; "A   "

            Temp = Strom_wert

            If temp > 1 Then
               'Umrechnung des Stromes nach Peukert
               Temp = Log(Temp)
               Temp = Temp + 0.356675        '+log(H/C)=log(20/14)=0.356675
               Temp = Temp * 0.2             'Multiplikation mit x=k-1
               Temp = Strom_wert * Exp(temp) 'Anwendung der e-Funktion
            End If

            Temp = Temp / 3600               'Strommessung pro Sekunde auf Ah umrechnen
            Batterie_kap = Batterie_kap - Temp       'restliche Batterieladung

            'Ausgabe der Stromsumme
            Z = Fusing(batterie_kap , "##.#")
            Locate 2 , 18 : Lcd Z ; "Ah   "

         Case 8:
            $include "Display_mode_8.bas"    'Display_mode for Manuel

      End Select

      Lcd_out_pin = 0                        'fr Oszillograph

   End If

Loop

End


'*******************************************************************************
'10 ************** Interruptregelung alle 10ms ********************************
'*******************************************************************************

Calculate_balance:

   '    damit im INT0 weiter die Geschwindigkeit gemessen werden kann
   Enable Interrupts

   Timer2 = Timer2_load                      'Timer2 neu laden fr Interrupt nach 10ms

   Incr Loop_count                           'Bei Loop_count=100 erfolgt LDC-Ausgabe 1x pro Sekunde

   If Loop_count = 20 Or Loop_count = 40 Or Loop_count = 60 Or Loop_count = 80 Or Loop_count = 100 Then
      Toggle Irq_led_pin
   End If

   '10a -------------- Strom- Spannung- Ladungsmessung -------------------------
   Adc7 = Adc7 + Getadc(7)                   'Stromsumme fr 1 Sekunde bilden

   Run_alt = Run                             'alte Stellung des Fuschalters speichern
   Run = 1 - Run_switch                      'Motorsteuerung durch Fuschalter aktivieren, RUN_Switch schaltet gegen Masse'0'
   D_run = Run - Run_alt                     'Wechsel feststellen, nach dem Einschalten D_run=1
   'nach dem Ausschalten D_run=-1 (=255=$FF, da Byte)

   If D_run > 127 Then                       'wenn Fuschalter ausgeschaltet wird,(D_run_Byte=255=-1)

      If Way_count > 0 Then
         Way_count_e = Way_count             'Gesamtweg im EERAM speichern, 0 vermeiden
      End If

      Batterie_kap_e = Batterie_kap          'Ladungszustand der Batterie speichern
   End If

   '10b ---------- Automatisches Ausschalten nach 5 min ------------------------

   If Run_count > 0 Then
      Decr Run_count                         'verzgertes Abschalten des PWM-Signals wenn Run_count=0 erreicht
   End If

   If Run = 1 Then                           'wenn Fuschalter gedrckt,dann
      Run_count = 166                        'fr verzgertes Abschalten von PWM bei Run=1 verhindern
      Timeout = 0                            'Zeitzhler fr automatisches Ausschalten lschen
   Else                                      '... wenn Run = 0 then ...
      Incr Timeout                           'Zeitzhler erhhen

      If Timeout > 30000 Then                'nach 5 Minuten ...
         Disable Interrupts
         Cls
         Lcd "* Automatisches*"
         Locate 2 , 1 : Lcd "* Ausschalten *"
         Call Musik
         Power_relais = 0                    'Relais nach 5 min ausschalten
         Do : Loop                           'und bis die Spannung abgefallen ist hier warten
      End If

   End If


   '10c --------------------- Geschwindigkeitsbegrenzung -----------------------

   '************** nicht aktiv ! ***********************************************

   '10d ---------- Ausschalten wegen zu starker Neigung und Stackwerte ---------

   If Run = 0 And Run_count = 0 Then         'verzgerte Notabschaltung nur bei Run=0, d.h. nicht whrend der Fahrt
      If Phi < -0.4 Or Phi > 0.4 Then        'Neigung zu stark ==> ausschalten
         Disable Interrupts
         Pwm1a = 0
         Pwm1b = 0
         For I = 1 To 3                      'mehrfaches Piepen
            Call Beep(3)
            Waitms 100
         Next I

         'Ausgabe der Stack-Werte beim Ausschalten

         Cls                                 'fr Ausgabe der Stack-Werte

         Lcd "HW:" ; _hw_lowest
         W = _hwstackstart - _hw_lowest
         Locate 2 , 1 : Lcd "HW stack needed :" ; W

         Wait 2 : Cls

         Lcd "FW:" ; _fw_highest
         If _fw_highest > 0 Then
            W = _frame_high - _fw_highest
            Locate 2 , 1 : Lcd "Frame space needed :" ; W
         End If

         Wait 2 : Cls

         Lcd "SW:" ; _sw_lowest
         W = _hwstack_low - _sw_lowest
         Locate 2 , 1
         Lcd "SW stack needed :" ; W
         Power_relais = 0
         Wait 5

      End If
   End If

   '10e ---------------------- Neigungswinkel messen ---------------------------

   Phi = Get_phi()                           'Winkel=Abweichung von der Ruhelage einlesen

   'Phi = Phi + Brems_phi  'Brems_Phi wird zur Geschwindigkeisbegrenzung verwendet

   Phi = Simple_filter(phi_alt , Phi , Filter_phi)       'Filterung fr Acc-Werte ab V.5.5.3
   Phi_alt = Phi                             'alten Wert fr Acc-Filter merken

   Help = Abs(phi)

   If Help < 0.02 Then
      Neigung_led = 1                        'LED-Anzeige fr "Senkrecht stehend" +-0.02
   Else
      Neigung_led = 0
   End If

   '10f ------------- Rotation einlesen und filtern ----------------------------

   Phi_rate = Get_phi_rate()                 'Phi_rate einlesen

   'Empfindlichkeit des Gyro's:  10mV/(/s)=1V/(100/s)=1V/(1,744rad/s)
   '              =5V/(8,72rad/s)=1024Bit/(8,72rad/s)= 1bit/(0,00852rad/s)

   Phi_rate = Phi_rate * 0.00852             'Phi_rate in rad/s umrechnen

   'Filterung fr Gyro-Werte         0.05 < Filterfaktor < 0.2   !!!!!!!!!!!!!!
   Phi_rate = Simple_filter(phi_rate_alt , Phi_rate , Filter_phi_rate)
   Phi_rate_alt = Phi_rate                   'alten Wert fr Gyro-Filter merken

   '10g ------------- Gier einlesen und filtern --------------------------------

   Gier = Get_gier()

   Gier = Gier_faktor * Gier
   Gier = Simple_filter(gier_alt , Gier , Filter_gier)
   Gier_alt = Gier

   '10h ------------- Lenkungswert einlesen und filtern ------------------------

   Adc5 = Getadc(5)                          'get steering value
   Lenkung = Adc5 - Lenkung_0                'remove offset

   Lenkung = Lenk_faktor * Lenkung
   Lenkung = Simple_filter(lenkung_alt , Lenkung , Filter_lenkung)
   Lenkung_alt = Lenkung

   '10i ------------ Lenkungswert berechnen und Mitte anzeigen -----------------

   Help = Abs(lenkung)
   If Help < 10 Then
      Lenkung_led = 1                        'Mittelstellung  9
   Else
      Lenkung_led = 0
   End If

   Lenkung = Lenkung + Gier                  'Gier-Korrektur

   '10j ---------------- Berechnung der Beschleunigung -------------------------

   '*** Die Beschleunigung geschwindigkeitsabhngig vergrern
   '*** Dynamische Beschleunigung zur Verbesserung der Balance bei hheren
   '*** Geschwindigkeiten Km_speed
   '*** km_speed steht 1 Mal pro Sekunde aus der Displayroutine zur Verfgung.
   '*** Ein proportional zur Geschwindigkeit vergrerter Beschleunigungswert
   '*** erhht die Stabilitt bei hheren Geschwindigkeiten.

   Help = Km_speed / Ref_speed_a             'for dymanic balance
   Help = Help + 1
   Phi = Phi * Help                          '*(1 + km_speed/ref_speed_a)
   Beschleunigung = A * Phi

   Help = Km_speed / Ref_speed_b             'for dymanic balance
   Help = Help + 1
   Phi_rate = Phi_rate * Help                '*(1 + km_speed/ref_speed_b)

   Help = B * Phi_rate

   Beschleunigung = Beschleunigung + Help    'Bestimmung der Beschleunigung

   Help = C * Beschleunigung                 'Berechnung der neuen Geschwindigkeit
   Help = Help * Dt
   Speed = Speed + Help

   Pwm = Beschleunigung + Speed              'Hier noch 0 < Pwm < 1

   '10k ------- Zu Beginn den Pwm_Faktor langsam ansteigen lassen --------------

   If Run = 1 Then                           'wenn Fuschalter gedrckt,dann
      If Pwm_faktor < Pwm_faktor_max Then    'langsames Ansteigen des PWM-Faktors
         Pwm_faktor = Pwm_faktor + 1         'Anstieg in Pwm_faktor_max * 10ms = 3,5s
      End If
   Else                                      'Wenn Fuschalter nicht gedrckt ist
      If Pwm_faktor > 2 Then
         Pwm_faktor = Pwm_faktor - 3         'langsames reduzieren des PWM-Faktors
      End If

      If Run_count < 3 Then                  'bei Run = 0 wird Run_count decrementiert
         Beschleunigung = 0                  '... nach 1,66 Sec verzgert alles ausschalten
         Speed = 0
         Pwm = 0
         Lenkung = 0
         Pwm1a = 0
         Pwm1b = 0
      End If

   End If

   '10L -------------- Berechnung der Motor-PWM-Werte --------------------------

   Lenkung = Lenkung / Pwm_faktor_max        'Anpassung wegen spterer Multiplikation

   Motor_pwm_r = Pwm + Lenkung
   Motor_pwm_r = Motor_pwm_r * Pwm_faktor

   Motor_pwm_l = Pwm - Lenkung
   Motor_pwm_l = Motor_pwm_l * Pwm_faktor

   '10m ------------------ Ausgabe der PWM-Werte -------------------------------

   'rechter Motor
   If Motor_pwm_r > 0 Then                   'Richtungen festlegen
      Pwm_dir_r = 1
   Else
      Pwm_dir_r = 0
      Motor_pwm_r = -1 * Motor_pwm_r         'Vorzeichen wechseln
   End If

   If Motor_pwm_r > Pwm_max Then
      Motor_pwm_r = Pwm_max                  'Maximalwert=500
   End If

   Pwm_word_r = Motor_pwm_r                  'nach Word konvertieren

   Pwm1a = Pwm_word_r                        'PWM_Werte ausgeben

   'linker Motor
   If Motor_pwm_l > 0 Then                   'Richtungen festlegen
      Pwm_dir_l = 1
   Else
      Pwm_dir_l = 0
      Motor_pwm_l = -1 * Motor_pwm_l         'Vorzeichen wechseln
   End If

   If Motor_pwm_l > Pwm_max Then
      Motor_pwm_l = Pwm_max                  'Maximalwert=500
   End If

   Pwm_word_l = Motor_pwm_l                  'nach Word konvertieren

   Pwm1b = Pwm_word_l                        'PWM_Werte ausgeben

Return

'------------------ Ende Regelinterrupt Neu_Rechnen ----------------------------
'===============================================================================

'*******************************************************************************
'11 ************** Interrupt fr Weg- und Geschwindigkeitsmessung *************
'*******************************************************************************
Incr_way_count:

   $asm
      .equ Way_count_1 = $100
      .equ Way_count_2 = $101
      .equ Way_count_3 = $102
      .equ Way_count_4 = $103

      push R24          'Register retten
      lds r24,sreg      'Statusregister einlesen und
      push r24          'auf den Stack schieben

      lds R24,way_count_1    'Byte_1 erhhen
      inc R24
      sts way_count_1 ,R24   'zurck schreiben
      brne Fertig

      lds R24,way_count_2    'Byte_2 erhhen
      inc R24
      sts way_count_2 ,R24   'zurck schreiben
      brne Fertig

      lds R24,way_count_3    'Byte_3 erhhen
      inc R24
      sts way_count_3 ,R24   'zurck schreiben
      brne Fertig

      lds R24,way_count_4    'Byte_4 erhhen
      inc R24
      sts way_count_4 ,R24   'zurck schreiben

Fertig:

      Pop R24           'Statusregister zurck holen
      sts sreg,R24      '... und zurckschreiben
      pop R24           'Register zurck holen
   $end Asm

Return

'*******************************************************************************
'12 ************** Initialisiere Sensoren *************************************
'*******************************************************************************

Sub Init_sensors
   '------------- Sensoren auslesen und Ruhewerte einstellen -----------

   '----------- Neigungswinkel einstellen
   Phi_0 = 0                                 'wird in Get_phi() benutzt, zum Justieren vorher=0 setzen
   Help = 0
   For I = 1 To 16
      Phi = Get_phi()
      Help = Help + Phi
      Waitms 20
   Next I

   Phi_0 = Help / 16                         'Mittelwert
   Phi_0_e = Phi_0                           'neuen Ruhewert im EERAM speichern

   Locate 2 , 1 : Lcd "Phi_0=   " ; Phi_0 ; "     "
   Call Beep(1)
   Wait 1

   '----------- Gyrosensor einstellen

   Phi_rate_0 = 0
   Help = 0

   For I = 1 To 16
      Phi_rate = Get_phi_rate()
      Help = Help - Phi_rate                 'Vorzeichenkorrektur
      Waitms 20
   Next I

   Phi_rate_0 = Help / 16                    'Mittelwert
   Phi_rate_0_e = Phi_rate_0                 'neuen Ruhewert im EERAM speichern

   Locate 2 , 1 : Lcd "Phi_rate_0=" ; Phi_rate_0 ; "     "
   Call Beep(1)
   Wait 1

   '----------- Giersensor einstellen

   Gier_0 = 0
   Help = 0

   For I = 1 To 16
      Gier = Get_gier()
      Help = Help - Gier                     'mit Vorzeichenkorrektur
      Waitms 20
   Next I

   Gier_0 = Help / 16                        'Mittelwert
   Gier_0_e = Gier_0                         'neuen Ruhewert im EERAM speichern

   Locate 2 , 1 : Lcd "Gier_0=" ; Gier_0 ; "     "
   Call Beep(1)
   Wait 1

   '----------- Lenker-Potentiometer

   Lenkung_0 = 0

   For I = 1 To 16
      Lenkung_0 = Lenkung_0 + Getadc(5)
      Waitms 20
   Next I

   Lenkung_0 = Lenkung_0 / 16                'Mittelwert
   Lenkung_0_e = Lenkung_0                   'neuen Ruhewert im EERAM speichern

   Locate 2 , 1 : Lcd "Lenkung_0=" ; Lenkung_0 ; "     "
   Call Beep(1)
   Wait 1

End Sub

'*******************************************************************************
'13 ************** Beep Tne erzeugen ******************************************
'*******************************************************************************

Sub Beep(byval Cn As Byte)                   'Anzahl: Cn kurze Beeps
   For I = 1 To Cn
      Sound Beep_pin , 300 , 900
      Waitms 20
   Next I
End Sub

'*******************************************************************************
'14 ************** Digitaler Simple Filter *************************************
'*******************************************************************************

'Function Simple_Filter(vorherigem Wert, neuem Wert, FilterFaktor)
Function Simple_filter(byval Wa As Single , Byval Wf As Single , Byval Af As Single) As Single

   'Filter = Wa * (1-a) + Wf * a   = Wa + a * (Wf - Wa)

   Wf = Wf - Wa
   Wf = Wf * Af
   Simple_filter = Wa + Wf                   'Returnwert
End Function

'*******************************************************************************
'15 ************** Startmelodie erzeugen ***************************************
'*******************************************************************************

Sub Musik
   Local C1 As Single

   C1 = _xtal / 12                           '=crystal/12

   Restore Musik1

   For I = 1 To 9
      Read T1 : Read F                       'Dauer und Frequenz lesen
      Help = C1 / F
      Pulsdauer = Help                       'Konvertierung nach word
      Help = T1 * F                          'T1=Dauer des Tones (in Sekunden)
      Tondauer = Help / 16
      Sound Beep_pin , Tondauer , Pulsdauer
      Waitms 20
   Next I
End Sub


'*******************************************************************************
'16 ************** Neigungswinkel einlesen *************************************
'*******************************************************************************

Function Get_phi()

   'Sensor_position = 1  ==> ADXL Anschlsse oben (auf Hauptplatine, Runner1)
   'Sensor_position = 2  ==> ADXL Anschlsse unten, auch Runner2

   Adc1 = Getadc(1)                          'ACC-Sensor X
   Adc2 = Getadc(2)                          'ACC-Sensor Y

   If Sensor_position = 1 Then
      Adc1 = Adc1 - Op_0                     'Nullpunkt subtrahieren
      Adc2 = Adc2 - Op_0                     'Nullpunkt subtrahieren
   End If

   If Sensor_position = 2 Then
      Adc1 = Op_0 - Adc1
      Adc2 = Op_0 - Adc2
   End If

   Help_phi = Adc2 / Adc1                    'help_phi=ADCL_Y/ADXL_X
   Help_phi = Atn(help_phi)                  'Phi=atn(ADCL_Y/ADXL_X), atn() needs 0.185ms
   Get_phi = Help_phi - Phi_0                'remove offset and return

End Function


'*******************************************************************************
'17 ************** Kipp- Rotation einlesen *************************************
'*******************************************************************************
'Adc3 und Adc4 sind bei Runner2 und Runner3 vertauscht

Function Get_phi_rate()                      'return a single

   If Runner_typ = 2 Or Runner_typ = 4 Or Runner_typ = 22 Then 'mein Runner2 und Manuels Runner4
      Adc4 = Getadc(4)                       'ADC4 = Gyrowert Kipprotation
      Get_phi_rate = Phi_rate_0 - Adc4       'Gyro-Ruhewert Differenz bilden (Vorzeichen!)
   End If

   If Runner_typ = 3 Then                    'fr Rainer
      Adc3 = Getadc(3)                       'ADC3 = Gyrowert Kipprotation
      Get_phi_rate = Phi_rate_0 - Adc3       'Gyro-Ruhewert Differenz bilden (Vorzeichen!)
   End If

End Function


'*******************************************************************************
'18 ************** Gier-Rotation einlesen *************************************
'*******************************************************************************

Function Get_gier()                          'return a single

   If Runner_typ = 2 Then                    'mein Runner2
      Adc3 = Getadc(3)                       'Rotation um die z-Achse
      Get_gier = Gier_0 - Adc3               'und Ruhewert subtrahieren
   End If

   If Runner_typ = 22 Or Runner_typ = 4 Then 'Runner2 mit altem Gyrosensor
      Adc3 = Getadc(3)                       'Rotation um die z-Achse
      Get_gier = Gier_0 + Adc3               'und Ruhewert subtrahieren
   End If

   If Runner_typ = 3 Then                    'fr Rainer Schwab
      Adc4 = Getadc(4)                       'Rotation um die z-Achse
      Get_gier = Gier_0 + Adc4               'und Ruhewert subtrahieren
   End If

End Function

'*******************************************************************************
'19 ********Read Parameters from ERAM and Calculate Check_summe ***************
'*******************************************************************************

Sub Calculate_cs(byval Store As Byte)

   Check_summe = 0
   Runner_typ = Runner_typ_e : Check_summe = Check_summe + Runner_typ
   Ref_speed_a = Ref_speed_a_e : Check_summe = Check_summe + Ref_speed_a
   Ref_speed_b = Ref_speed_b_e : Check_summe = Check_summe + Ref_speed_b
   Int0_way = Int0_way_e : Check_summe = Check_summe + Int0_way
   Lenk_faktor = Lenk_faktor_e : Check_summe = Check_summe + Lenk_faktor
   Gier_faktor = Gier_faktor_e : Check_summe = Check_summe + Gier_faktor
   U_batt_faktor = U_batt_faktor_e : Check_summe = Check_summe + U_batt_faktor
   Pwm_max = Pwm_max_e : Check_summe = Check_summe + Pwm_max
   Pwm_faktor_max = Pwm_faktor_max_e : Check_summe = Check_summe + Pwm_faktor_max
   A = A_e : Check_summe = Check_summe + A
   B = B_e : Check_summe = Check_summe + B
   C = C_e : Check_summe = Check_summe + C
   Filter_phi = Filter_phi_e : Check_summe = Check_summe + Filter_phi
   Filter_phi_rate = Filter_phi_rate_e : Check_summe = Check_summe + Filter_phi_rate
   Filter_gier = Filter_gier_e : Check_summe = Check_summe + Filter_gier
   Filter_lenkung = Filter_lenkung_e : Check_summe = Check_summe + Filter_lenkung
   Display_mode = Display_mode_e : Check_summe = Check_summe + Display_mode
   U_min1 = U_min1_e : Check_summe = Check_summe + U_min1

   If Store = 1 Then
      Check_summe_e = Check_summe
   End If

End Sub

'*******************************************************************************
'20 ********************* Update Parameters ***********************************
'*******************************************************************************

Sub Update_parameters

   Do
      Cls

      Lcd "Select Parameter:"
      Locate 2 , 1
      Lcd "<ESC> to finish"

      Call Getkey

      Select Case Key

         Case 85:
            V_str = "U_min1"
            Renew U_min1                     'key U was pressed
            U_min1_e = U_min1                'store new value to ERAM

         Case 68:
            Help = Display_mode              'convert to single
            V_str = "Display_mode"
            Renew Help       'key D was pressed
            Display_mode = Help              'convert to Byte
            Display_mode_e = Display_mode    'store new value to ERAM

         Case 66:
            V_str = "U_batt_faktor"
            Renew U_batt_faktor              'key B was pressed
            U_batt_faktor_e = U_batt_faktor  'store new value to ERAM

         Case 82:
            Help = Runner_typ                'Convert to single
            V_str = "Runner_typ"
            Renew Help                       'key R was pressed
            Runner_typ = Help                'convert to Byte
            Runner_typ_e = Runner_typ        'store new value to ERAM

         Case 83:
            V_str = "Ref_speed_A"
            Renew Ref_speed_a               'key S was pressed
            Ref_speed_a_e = Ref_speed_a      'store new value to ERAM
            Call Beep(1)
            Cls
            V_str = "Ref_speed_B"
            Renew Ref_speed_b                'key S was pressed
            Ref_speed_b_e = Ref_speed_b      'store new value to ERAM

         Case 87:
            V_str = "Int0_way"
            Renew Int0_way                  'key W was pressed
            Int0_way_e = Int0_way            'store new value to ERAM

         Case 201:
            V_str = "Parameter A"
            Renew A                          'key F1 was pressed
            A_e = A                          'store new value to ERAM

         Case 202:
            V_str = "Parameter B"
            Renew B                          'key F2 was pressed
            B_e = B

         Case 203:
            V_str = "Parameter C"
            Renew C                          'key F3 was pressed
            C_e = C

         Case 204:

            'Reserve

         Case 205:
            V_str = "Filter_phi"
            Renew Filter_phi                 'key F5 was pressed
            Filter_phi_e = Filter_phi

         Case 206:
            V_str = "Filter_phi_rate"
            Renew Filter_phi_rate            'key F6 was pressed
            Filter_phi_rate_e = Filter_phi_rate

         Case 207:
            V_str = "Filter_gier"
            Renew Filter_gier                'key F7 was pressed
            Filter_gier_e = Filter_gier

         Case 208:
            V_str = "Filter_lenkung"
            Renew Filter_lenkung             'key F8 was pressed
            Filter_lenkung_e = Filter_lenkung

         Case 209:
            V_str = "Lenk_faktor"
            Renew Lenk_faktor                'key F9 was pressed
            Lenk_faktor_e = Lenk_faktor

         Case 210:
            V_str = "Gier_faktor"
            Renew Gier_faktor                'key F10 was pressed
            Gier_faktor_e = Gier_faktor

         Case 211:
            V_str = "Pwm_max"
            Renew Pwm_max                    'key F11 was pressed
            Pwm_max_e = Pwm_max

         Case 212:
            V_str = "Pwm_faktor_max"
            Renew Pwm_faktor_max             'key F12 was pressed
            Pwm_faktor_max_e = Pwm_faktor_max

         Case 27:
            Call Calculate_cs(1)             'Read Parameters from ERAM and calculate and store check_summe

         Case "P":
            Call Restore_parameters          'Restore My_Parameters
            Call Calculate_cs(1)             'Read Parameters from ERAM and calculate and store check_summe
            Cls
            Lcd "Restore old"
            Locate 2 , 1
            Lcd "   My_Parameters"
            Beep 10

      End Select

   Loop Until Key = 27                       'ESC to finish and calculate new check_summe

   Cls
   Lcd "New parameters set"
   Call Auto_restart
End Sub

'*******************************************************************************
'21 ****************** Sub Getkey from a PS/2 keyboard at Port D ***************
'*******************************************************************************
Sub Getkey                                   'key liefert den ASCII-Code der Taste
   Do
      Key = Getatkbd()
   Loop Until Key <> 0

   If Key > 96 And Key < 123 Then Key = Key - 32       'in Grobuchstaben umwandeln
   If Key > 32 Then Lcd Chr(key)
   Waitms 100
End Sub

'*******************************************************************************
'22 ******************** Renew a parameter *************************************
'*******************************************************************************
Sub Renew(v_val As Single)
   Local In_string As String * 10
   Local String_val As Single

   In_string = ""                            'takes input string
   Cls
   Lcd V_str                                 'show variable name
   Locate 2 , 1

   Lcd "old:" ; Fusing(v_val , "###.###")    'show old value
   Locate 2 , 10
   Lcd "=>"
   Key = 0

   Do
      Call Getkey                            'get one character
      In_string = In_string + Chr(key)       'create to a string
   Loop Until Key = 13 Or Len(in_string) = 5 'no <RET>

   If Len(in_string) > 1 Then                'a new value is present

      Call Beep(1)
      String_val = Val(in_string)            'convert to a single

      Cls
      Lcd "old:" ; Fusing(v_val , "###.###")
      Locate 2 , 1
      Lcd "new:" ; Fusing(string_val , "###.###") ; " Y/N:"

      Call Getkey
      ' Lcd Key
      If Key = 89 Then                       'Chr(key) = "Y"
         V_val = String_val
         Call Beep(1)
         Wait 1
      End If
   End If
   Cls
End Sub

'*******************************************************************************
'23 ************************** Auto_Restart*************************************
'*******************************************************************************

Sub Auto_restart
   Locate 2 , 1
   Lcd "** Auto Restart Runner **"
   Auto_restart_e = 1                        'for Auto_Restart next time
   Config Watchdog = 1024
   Start Watchdog                            'to Restart Controller now
End Sub

'*******************************************************************************
'24 ************************ Restore_parameters ********************************
'*******************************************************************************

Sub Restore_parameters

   $include "My_Parameters.bas"              'Write safe Parameters to ERAM

End Sub Restore_parameters

'******************** Convert Keyboard code to ASCII code **********************
Tabelle:
   'ordnet dem ScannCode der Tastatur einen ASCII-Wert zu
   'normal keys lower case  , y und z fr deutsche Tastatur
   Data 0 , 209 , 0 , 205 , 203 , 201 , 202 , 212 , 0 , 210 , 208 , 206 , 204 , 0 , &H5E , 0
   Data 0 , 0 , 0 , 0 , 0 , 113 , 49 , 0 , 0 , 0 , 121 , 115 , 97 , 119 , 50 , 0
   Data 0 , 99 , 120 , 100 , 101 , 52 , 51 , 0 , 0 , 32 , 118 , 102 , 116 , 114 , 53 , 0
   Data 0 , 110 , 98 , 104 , 103 , 122 , 54 , 7 , 8 , 44 , 109 , 106 , 117 , 55 , 56 , 0
   Data 0 , 44 , 107 , 105 , 111 , 48 , 57 , 0 , 0 , 46 , 45 , 108 , 59 , 112 , 43 , 0
   Data 0 , 0 , 0 , 0 , 0 , 92 , 0 , 0 , 0 , 0 , 13 , 0 , 0 , 92 , 0 , 0
   Data 0 , 60 , 0 , 0 , 0 , 0 , 8 , 0 , 0 , 49 , 0 , 52 , 55 , 0 , 0 , 0
   Data 48 , 44 , 50 , 53 , 54 , 56 , 27 , 0 , 211 , 43 , 51 , 45 , 42 , 57 , 0 , 0

   'shifted keys UPPER case  , Y und Z fr deutsche Tastatur
   Data 0 , 0 , 0 , 207 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
   Data 0 , 0 , 0 , 0 , 0 , 81 , 33 , 0 , 0 , 0 , 89 , 83 , 65 , 87 , 34 , 0
   Data 0 , 67 , 88 , 68 , 69 , 0 , 35 , 0 , 0 , 32 , 86 , 70 , 84 , 82 , 37 , 0
   Data 0 , 78 , 66 , 72 , 71 , 90 , 38 , 0 , 0 , 76 , 77 , 74 , 85 , 47 , 40 , 0
   Data 0 , 59 , 75 , 73 , 79 , 61 , 41 , 0 , 0 , 58 , 95 , 76 , 48 , 80 , 63 , 0
   Data 0 , 0 , 0 , 0 , 0 , 96 , 0 , 0 , 0 , 0 , 13 , 94 , 0 , 42 , 0 , 0
   Data 0 , 62 , 0 , 0 , 0 , 8 , 0 , 0 , 49 , 0 , 52 , 55 , 0 , 0 , 0 , 0
   Data 48 , 44 , 50 , 53 , 54 , 56 , 27 , 0 , 211 , 43 , 51 , 45 , 42 , 57 , 0 , 0

   '  Data 0 , F9 , 0 , F5 , F3 , F1 , F2 , F12 , 0 , F10 , F8 , F6 , F4 , 0 , &H5E , 0
   '  Data 0 , 0 , 0 , 0 , 0 , Q , 1 , 0 , 0 , 0 , Y , S , A , W , 2 , 0
   '  Data 0 , C , X , D , E , 4 , 3 , 0 , 0 , Space , v , f , t , r , 5, 0
   '  Data 0 , n , b , h , g , z , 6 , Bell , Backspace , Komma , m , j , u , 7 , 8 , 0
   '  Data 0 , vertical tab , k , i , o , 0 , 9 , 0 , 0 , Punkt , - , l , ; , p , + , 0
   '  Data 0 , 0 , 0 , 0 , 0 , \ , 0 , 0 , 0 , 0 , CR , 0 , 0 , \ , 0 , 0
   '  Data 0 , < , 0 , 0 , 0 , 0 , 8 , 0 , 0 , 1 , 0 , 4 , 7 , 0 , 0 , 0
   '  Data 0 , Komma , 2 , 5 , 6 , 8 , ESC , 0 , E , + , 3 , - , * , 9 , 0 , 0



'******************** Data for Play Musik **************************************

Musik1:
   Data 4! , 523! , 4! , 587! , 4! , 659! , 4! , 523! , 4! , 587! , 8! , 659! , 4! , 494! , 8! , 587! , 12! , 523!
