'================================================================??=============
'=          Runner AT32-Platine mit vollstndiger Steuerung fr Runner/Segway
'=          (C) W. Schmidt, 183600@gmail.com
'=
'= V7.00    Umstellung auf den digitalen Sensor MPU-6050, bernahme von V6.42
'= V7.01    Unterprogramme fr analoge Sensoren Acc und Gyro entfernt
'=          [-Function Calculate_phi(), -Function Calculate_phi_rate() und -Function Calculate_gier()]
'=          Runner luft, Filter noch nicht optimiert.
'= V7.02    Experimente mit Filtereinstellungen
'= V7.03    Alte Filtereinstellungen aus 6.42 bernommen.
'= V7.04    Keyboarderkennung auch bei eingeschaltetem Runner, bei Run=0
'=          Filtereinstellungen angepasst, diese Version ist funktionsfhig.
'=          Dynamische Blanceregelung nicht aktiviert.
'= V7.05    Weitere Optimierung von Variablen und Filtern
'=          Im Display-mode=3 wird am Ende der Ausgabe der Loop_count-Wert ausgegeben
'=          Er zeigt statt Ah die Anzahl der Interrupts whrend der Display-Ausgabe an
'=          und somit die relative CPU-Auslastung. Stackberwachung entfernt.
'=
'= V7.06    Programmstart geordnet, Display-Positionen gendert, VCC von USB-Anschluss erkennen
'= V7.07    CPU-Auslastung durch das Auszhlen der Hauptschleifendurchlufe in einer Sekunde
'=          Ein Durchlauf ohne LCD und IRQ erfordert 29 (39) Takte, d.h. max. 512820 Durchlufe
'=          bei $crystal = 20MHz, Probefahrt bis 10km/h

'= V7.08    Taste F4 mit Parametereinstellung fr Referenzgeschwindigkeiten
'=          der dynamischen Balanceregelung belegt.
'=          Daten der Datei "My_Parameters" wurden in das Hauptprogramm integriert,
'=          da keine Unterscheidung verschiedener Runner erfolgt.
'=          Key "O" zum erneuern der Offsetwerte.
'=          Push-Pop-Fehler beseitigt
'=          V7.08c mit Push-Pop ohne die Saveall Option fr ltere Compiler
'=
'= V7.09    PWM-Mode 2 fr BTS7960 H-Bridge
'=          Auf PCB JP7/2-3 PinC.6 mit Jumper gegen GND
'=          neue Zeilen: 141,142,149-152,955,958,972,976
'=          Fehler bei der Messung der Auslastung beseitigt, bentigt doch 39+1=40 Takte

'= V7.10    Compiled for Atmega324PA/20MHz and Atmega32A/16MHz
'=
'= V7.11    Testprogramm integriert.
'= V7.14    Keyboard fr Testmode eingerichtet
'= V7.15    Keyboard-Erkennung nur nach Startmusik !, Div. Anpassungen
'= V7.20    ... verffentlicht.
'= V7.21    Korrektur der Displayausgabe bei Lenker-Test
'= V7.22    "BTS"-Anzeige im Display
'= V7.23    Reihenfolge im Testmodus gendert
'= V7.24    Im Parametermodus wird auch das Power_Relais eingeschaltet, wenn die Spannung stimmt.
'= V7.25    Timer2_load und Freeloop_ref werden fortan berechnet
'=          Config Timer1 wurde verschoben
'=          ... verffentlicht
'= V7.27    Mit optimiertem Komplementrfilter aus der Arbeit von STEFAN KNEPPLE-GUGGEMOS
'=          Config Timer1 wurde zurck geschoben (2d)
'= V7.28    U_batt = Get_U_batt() , Filter_komp(lementr)  eingepflegt
'= V7.29    Neue Filterdefinition mit Filter_MPU6050, Filter_phi_rate entfllt
'= V7.30    -neu "Call Power_off" zum Ausschalten, "Call Power_on" zum Einschalten
'=          -versuchsweise nach Config LCD das LCD-Bit RS=0 gesetzt - keine Verbesserung beim Display
'=          -Anzeige versch. Maximalwerte auf LCD beim nchsten Start, RS=0 entfernt.
'=          -"K" bei der Parametereinstellung zur Eingabe der Batteriekapazitt
'=          -> verffentlicht
'= V7.31    Parameter "Filter_mpu6050" aktiviert
'= V7.33    Absolute Winkelmessung im Testmodus fr Sensoreinstellung
'= V7.34    Adressierung fr "Way_Count" gendert  -> {Way_count}
'=          Winkeleinstellung +-3 fr Testmodus*
'= V7.35    Verbesserung PID-Filter (Integral optimiert) mit Parameter D,
'=          seitliche Kipperkennung hinzugefgt (Acz)
'=          Ausschaltgrenze fr seitliche Neigung Acz auf 3500 gendert.
'= V7.36    PWM-Mode 2 fr BTS7960 aus V7.09 wurde entfernt
'=          Neue PWM-modi fr verschiedene PWM-Frequenzen eingefgt.
'=          Parameter fr PWM-Frequenzen mit F10 ndern.
'=          max. Acz_offset-Abweichung wegen Error=16 auf 300 gendert.
'=          Wartezeit fr U_min auf 10s festgelegt.
'=          Parameter U_batt0_e = 25(V) festgelegt. Ggf. mit Tastatur auf 37.5(V) ndern.
'=          45-Test vereinfacht
'= V7.36b   PWM-Mode = 1 fr Testmode festgelegt,
'=          Bug bei Pwm_max und Pwm_faktor_max beseitigt
'= V7.36c   ... EERAM-Werte nach Keyboardeinstellung ebenfalls angepasst (2x erforderlich)
'= V7.36d   Sensorerror wird beim Start angezeigt
'=          Init I2C-Bus und Init MPU6050 zusammengefasst
'= V7.36e   10ms-Timer2 auch fr Test_modus verwendet. Wird im Testmode angepasst.
'=          Timer0 freigegeben. Speichern/Anzeige von Maximalwerten beim Start entfernt.
'= V7.37    Zahleneingabe fr A,B,D um Faktor 100 vergrert/vereinfacht.
'= V7.38    Der PWM_max im Testmodus wurde auf 100(25V) bzw. 60(37.5V) begrenzt
'=
'===============================================================================

'*******************************************************************************
'00                 Compilereinstellungen                                      *
'*******************************************************************************

$hwstack = 128                                    '73
$framesize = 164                                  '92
$swstack = 128                                    '7
$crystal = 16000000                               'alle Runner

$regfile = "m32Adef.dat"                          'fr Mega32A
'$regfile = "m2560def.dat "                        'fr Mega2560

'$prog &HFF , &HEE , &HD1 , &H00                   ' fr ID: 1E9502
$prog &HFF , &HFE , &HD1 , &H00                   ' generated. Take care that the chip supports all fuse bytes.
'$prog &HFF , &HEE , &HD1 , &H00                   ' generated. Take care that the chip supports all fuse bytes.

'$prog &HFF , &HEE , &HD1 , &HF8                   ' generated. Take care that the chip supports all fuse bytes.

'$regfile = "m324PAdef.dat"                        'fr Mega324 mit ID 1E9511
'$prog &HFF , &HDE , &HD1 , &HF8                   'fr Atmega324PA


'*******************************************************************************
'01                 Dimensionierung von Variablen                              *
'*******************************************************************************

Const V_ersion = "7.38"                           'Software version

'----------------- Variable fr Assembler-Interrupt Wegmessung -----------------
Dim Way_count As Dword                            'Wegzhler, siehe auch im Assemblerteil
Dim Way_count_temp As Dword                       'zum Zwischenspeichern
Dim Way_count_alt As Dword , Way_count_alt_2 As Dword , Way_count_diff As Dword
Dim Loop_count As Byte                            'LCD-Ausgabe bei neuen Daten signalisieren
Dim Runner_typ As Byte

'-------------------------------------------------------------------------------
Dim Pwm_word_r As Word , Pwm_word_l As Word       'PWM-Werte als Word
Dim Motor_pwm_r As Single , Motor_pwm_l As Single 'PWM-Werte als Single
Dim Dt As Single , Help As Single , Temp As Single       'temp Variable in Displayroutine

Dim Adc0 As Word , Adc5 As Word , Adc7 As Word , Adc7_temp As Word
Dim Phi As Single , Phi_0 As Single               'vertical tilt
Dim Phi_rate As Single , Phi_rate_0 As Single , Brems_phi As Single

Dim A As Single , B As Single , C As Single , D As Single

Dim Lenkung_0 As Word , Timeout As Word , I As Word , I_max As Word , Mod_timeout As Word
Dim Run As Byte , D_run As Byte , Run_alt As Byte , Display_mode As Byte

Dim Lenkung As Single , Lenkung_alt As Single , Lenk_faktor As Single
Dim Gier_0 As Single , Gier As Single , Gier_faktor As Single , Gier_alt As Single

Dim Beschleunigung As Single , Speed As Single , Integral As Single       ', V_max As Single
Dim Pwm As Single , Pwm_alt As Single , Pwm_faktor As Single , Pwm_faktor_max As Single
Dim U_batt_faktor As Single , Speed_faktor As Single
Dim Key As Byte , Testps2 As Byte , Error As Byte
Dim Pwm_max As Single , J As Byte , Timer2_load As Byte , Pwm_mode As Byte

Dim Km_speed As Single , Km_speed_max As Single , Trip As Single , Trip_faktor As Single
Dim U_batt As Single , U_min As Single , Display_count As Byte , Z As String * 16
Dim Run_count As Byte , Strom_wert As Single , Batterie_kap As Single , U_batt0 As Single
Dim Batterie_kap0 As Single , U_min1 As Single , U_min2 As Single
Dim Ref_speed_a As Single , Ref_speed_b As Single , Int0_way As Single

Dim Filter_komp As Single , Filter_mpu6050 As Single , Filter_gier As Single , Filter_lenkung As Single
Dim Phi_alt As Single , Z_single As Single

Dim Overspeed As Single , Overspeed_integral As Single

Dim F As Single , T1 As Single , Tondauer As Word , Pulsdauer As Word       'Frequenz

Dim Check_summe As Single , V_str As String * 20
Dim Auslastung As Dword , Freilauf As Dword , Freeloop_ref As Dword

'--------------------------- Variable im ERAM ----------------------------------
Dim Dummy As Eram Word , Way_count_e As Eram Dword , Lenkung_0_e As Eram Word ,
Dim Phi_rate_0_e As Eram Single , Gier_0_e As Eram Single , Batterie_kap_e As Eram Single
Dim Phi_0_e As Eram Single , Error_e As Eram Byte , Batterie_kap0_e As Eram Single , U_batt0_e As Eram Single

Dim Ref_speed_a_e As Eram Single , Ref_speed_b_e As Eram Single , Int0_way_e As Eram Single , Lenk_faktor_e As Eram Single
Dim Gier_faktor_e As Eram Single , U_batt_faktor_e As Eram Single , Display_mode_e As Eram Byte
Dim A_e As Eram Single , B_e As Eram Single , C_e As Eram Single , D_e As Eram Single , Filter_komp_e As Eram Single
Dim Filter_mpu6050_e As Eram Single , Filter_gier_e As Eram Single
Dim Filter_lenkung_e As Eram Single , Pwm_max_e As Eram Single , Runner_typ_e As Eram Byte
Dim Pwm_faktor_max_e As Eram Single , Check_summe_e As Eram Single , Quick_restart_e As Eram Byte
Dim Acz_0_e As Eram Integer , Pwm_mode_e As Eram Byte

'Variable fr Maximalwerte
Dim Pwm_high As Single , Strom_max As Single , V_max As Single , Phi_max As Single
Dim Pwm_high_e As Eram Single , Strom_max_e As Eram Single , V_max_e As Eram Single , Phi_max_e As Eram Single


'Variable fr digital Sensor
Dim Acx As Integer , Acy As Integer , Acz As Integer , Acz_0 As Integer
Dim Gyx As Integer , Gyy As Integer , Gyz As Integer , Sens_temp As Integer
Dim H_byte As Byte , L_byte As Byte
Dim Gier_x As Single , Gier_y As Single , Gyz_0 As Single
Dim Adr_write As Byte , Adr_read As Byte

'Variable fr Komplementrfilter II
Dim B_1 As Single , Help1 As Single , Help2 As Single , Help3 As Single

'*******************************************************************************
'02                 Declarationen und Konfigurationen (Sub, I/O)               *
'*******************************************************************************

Declare Sub Beep(byval Cn As Byte)                'Cn kurze Beeps
Declare Sub Musik
Declare Sub Menue
Declare Sub Update_parameters
Declare Sub Read_par_calc_cs(byval Store As Byte) 'Calculate Check_summe and write to ERAM
Declare Sub Getkey                                'Getkey liefert den ASCII-Code der Taste
Declare Sub Renew(byref V_val As Single)
Declare Sub Auto_restart                          'No musik, no waits
Declare Sub Restore_parameters
Declare Sub Calculate_offsets
Declare Sub Init_mpu()
Declare Sub Read_6050(acc_x As Integer , Acc_y As Integer , Acc_z As Integer , Gyr_x As Integer , Gyr_y As Integer , Gyr_z As Integer , Sens_temp As Integer)

Declare Sub Runnerboard_test
Declare Sub Power_off
Declare Sub Power_on

Declare Function Calculate_gier() As Single
Declare Function Calculate_phi_rate() As Single
Declare Function Calculate_phi() As Single
Declare Function Simple_filter(byval Wa As Single , Byval Wf As Single , Byval Af As Single) As Single
Declare Function Get_u_batt() As Single

Power_relais Alias Portc.0 : Config Power_relais = Output : Power_relais = 0       'an Transistor fr Relais
Run_switch Alias Pinc.1 : Config Run_switch = Input : Portc.1 = 1       'Pullup aktiviert fr Fuschalter
Irq_led_pin Alias Portc.2 : Config Irq_led_pin = Output       'LED auf Platine zeigt aktiven IRQ an
Neigung_led Alias Portc.3 : Config Neigung_led = Output       'Kontrollpin Neigung in Ruhestellung
Lenkung_led Alias Portc.4 : Config Lenkung_led = Output       'Kontrollpin Lenkung in Ruhestellung
Beep_pin Alias Portc.5 : Config Beep_pin = Output 'Ausgang fr Pieper
Bts7960_pin Alias Pinc.6 : Config Bts7960_pin = Input : Portc.6 = 1       'BTS7960_Pin mit Pullup
Test_modus Alias Pinc.7 : Config Test_modus = Input : Portc.7 = 1       'Aktivierung des Testmodus mit Pullup

Pwm_dir_l Alias Portd.6 : Config Pwm_dir_l = Output
Pwm_dir_r Alias Portd.7 : Config Pwm_dir_r = Output

Config Portd.4 = Output                           'Fr Atmega324 erforderlich
Config Portd.5 = Output                           'Fr Atmega324 erforderlich

'Einstellungen, damit der Motor beim Einschalten nicht anluft
Portd.4 = 1                                       'PWM_R
Portd.5 = 1                                       'PWM_L

'2a---------------- LCD - Displayausgabe konfigurieren -------------------------
Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portb.5 , Rs = Portb.4
Config Lcd = 24x2 : Config Lcdbus = 4

'2b---------------- INT0 Weg-Geschwindigkeitsmessung konfigurieren -------------
Config Int0 = Falling
On Int0 Incr_way_count Nosave
Enable Int0

'2d---------------- Timer1 als PWM-Timer konfigurieren -------------------------
Config Timer1 = Pwm , Pwm = 9 , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down , Prescale = 1

'2e---------------- Timer2 als Zeitbasis fr Interrupt alle 10ms ---------------
Config Timer2 = Timer , Prescale = 1024
On Timer2 Calculate_balance Saveall               'Wird im Testmode gendert
'Enable Timer2 'wird spter eingeschaltet

'2f---------------- AD-Wandler konfigurieren Uref=Vcc=5Volt --------------------
Config Adc = Single , Prescaler = Auto , Reference = Avcc : Start Adc

'2g---------------- Config PS/2 keyboard ---------------------------------------
Config Keyboard = Pind.0 , Data = Pind.1 , Keydata = Tabelle
Portd.0 = 1 : Portd.1 = 1                         'Pullup aktivieren


'*******************************************************************************
'03                 Initialisierungen                                          *
'*******************************************************************************
Cls
Lcd "* Runner Version " ; V_ersion ; "   "
Locate 1 , 24 : Lcd "*"

'Referenzwert fr Auslastungsberechnung (siehe Butler V0.30)
Freeloop_ref = _xtal / 4000

'Berechnung des Timerwertes fr 10ms:   _xtal/(1024*100) fr 10ms
Freilauf = _xtal / 102400                         'Freilauf als D_Word-Hilfsvariable
Freilauf = 256 - Freilauf                         'Freilauf als Hilfsvariable: DWord
Freilauf = Freilauf + 1                           '+1 Rundungsausgleich

Timer2_load = Freilauf

Timer2 = Timer2_load                              'Timer2 prepare

'3a---------- Fuschaltertest-Test (beim Start prfen) -------------------------

If Run_switch = 0 Then                            'Wenn der Fuschalter beim Einschalten gedrckt ist,
   Error_e = 99                                   'wird ein scheinbarer Fehler markiert, um einen Neustart
   Error = Error_e
   Cls                                            'mit Neueinstellung der Sensorwerte auszulsen.
   'Wenn beim Start ein Fuschalter klemmt oder
   'gedrckt wird, erscheint ebenfalls diese Fehlermeldung.
   Lcd "***  ERROR=" ; Error ; " ***"
   Locate 2 , 1
   Lcd "  Please restart !"
End If

If Quick_restart_e = 0 Then                       'normal Start mit Musik
   Call Musik                                     'Power_Up fr Kondensatoren abwarten
Else                                              'Spannung noch ausreichend
   Power_on : Quick_restart_e = 0                 'dann Relais sofort einschalten
End If


'3b---------------- Read previous offset values form ERAM ----------------------
Lenkung_0 = Lenkung_0_e                           'Offset aus dem ERAM auslesen
Phi_0 = Phi_0_e                                   'Offset aus dem ERAM auslesen
Acz_0 = Acz_0_e                                   'Offset aus dem ERAM auslesen
Phi_rate_0 = Phi_rate_0_e                         'Offset aus dem ERAM auslesen
Gier_0 = Gier_0_e                                 'Offset aus dem ERAM auslesen
Way_count = Way_count_e                           'km-Zhler aus dem ERAM auslesen
Batterie_kap = Batterie_kap_e                     'verbleibende Kapazitt aus dem ERAM auslesen

'3b1------------ Read parameter from ERAM and calculate checksumme -------------

Call Read_par_calc_cs(0)                          'Read Parameters from ERAM and calculate CS, no store

Help = Check_summe_e                              'Read old check_summe from ERAM


'--------------- Compare Check_summe with previous Check_summe --------------
'A check_summe error occures using a new controler without parameters
If Check_summe <> Help Then                       'load parameters and recalculate checksumme
   Cls
   Lcd "*Check_summ Error*"
   Locate 2 , 1
   Lcd "Restore Parameters"
   Call Beep(10)

   Call Restore_parameters
   Call Read_par_calc_cs(1)                       'Read Parameters from ERAM, calculate and store check_summe(1)

   Cls : Lcd "*Restart Runner*"
   Call Auto_restart                              'No musik, no waits
End If

B_1 = 1 - Filter_komp                             ' (1-b) fr Komplementrfilter berechnen

'Spannungsgrenzen festlegen fr U_batt0 = 37.5V (und 25V)
U_min1 = U_batt0 * 0.9                            '= 33.75V bei U_batt = 37.5V
U_min2 = U_batt0 * 1.1                            '= 41,25V bei U_batt = 37.5V

'3b2-------------- alternative PWM-Configuration f=7.8kHz/10.4kHz --------------
'      hochzhlen des Timers bis zum Inhalt von ICR1
'      Die Parameter Pwm_faktor_max und PWM_max mssen angepasst werden!

Select Case Pwm_mode

   Case 1
      'Standardconfiguration mit Config Timer1
      Tccr1a = &B11110010                         'wie Config (mode2)
      Tccr1b = &B00000001                         'wie Config (mode2)
      'PWM mit 9 Bit = 512 Werte                   f=15.5kHz

   Case 2
      'Anpassung von PWM_max und Pwm_faktor_max fr eine Auflsung bis 768
      Tccr1a = &B11110000                         'fr Atmega_mode 8
      Tccr1b = &B00010001                         'fr Atmega_mode 8
      Icr1 = 768                                  'f=10.4kHz bei Atmega_mode 8
      Pwm_max = Pwm_max * 1.5
      Pwm_faktor_max = Pwm_faktor_max * 1.5

   Case 3
      'Anpassung von PWM_max und Pwm_faktor_max fr eine Auflsung bis 1024
      Tccr1a = &B11110000                         'fr Atmega_mode 8
      Tccr1b = &B00010001                         'fr Atmega_mode 8
      Icr1 = 1024                                 'f=7.8kHz  bei Atmega_mode 8
      Pwm_max = Pwm_max * 2
      Pwm_faktor_max = Pwm_faktor_max * 2

   Case 4
      'Anpassung von PWM_max und Pwm_faktor_max fr eine Auflsung bis 2048
      Tccr1a = &B11110010                         'fr Atmega_mode 14
      Tccr1b = &B00011001                         'fr Atmega_mode 14
      Icr1 = 1536                                 'f=10.4kHz  bei Atmega_mode 14
      Pwm_max = Pwm_max * 3
      Pwm_faktor_max = Pwm_faktor_max * 3

   Case 5
      'Anpassung von PWM_max und Pwm_faktor_max fr eine Auflsung bis 2048
      Tccr1a = &B11110010                         'fr Atmega_mode 14
      Tccr1b = &B00011001                         'fr Atmega_mode 14
      Icr1 = 2048                                 'f=7.8kHz  bei Atmega_mode 14
      Pwm_max = Pwm_max * 4
      Pwm_faktor_max = Pwm_faktor_max * 4

End Select

'3b3--------------- Iinitialisierung des MPU6050 Sensors -----------------------

Waitms 30
Call Init_mpu()
Waitms 30
Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)       'Dummyread
Waitms 10

'--- Prfen, ob ein Keyboard angeschlossen wurde ---
Locate 1 , 1
For I = 1 To 2000

   Mod_timeout = I Mod 80                         '2000/80 = 25 "*" ausgeben
   If Mod_timeout = 0 Then Lcd "*"

   Testps2 = Pind And 3                           'Look for a keyboard at Port D
   If Testps2 < 3 Then
      Cls
      Lcd "*    Keyboard found    *"
      Locate 2 , 1
      Lcd "*   Update Parameter   *"
      Beep 1
      Wait 1
      Call Update_parameters                      'goto update parameters and auto restart
   End If
   Waitms 1
Next I

'---------------- Show Start Screen --------------------------------------------
'---------- Spannungsanstieg und PS/2-keyboard prfen --------------------------
Cls

U_batt = Get_u_batt()                             'Batteriespannung messen

If U_batt < 6 Then                                'Prfe Spannungsversorgung USB
   Lcd "   Connected to USB     "                 'kein Relais einschalten
   Beep 3
   Locate 2 , 1
   U_batt = Get_u_batt()                          'Batteriespannung messen
   Locate 2 , 1
   Z = Fusing(u_batt , "##.##")
   Lcd "*    Batterie:" ; Z ; "       "
   Locate 2 , 24 : Lcd "*"
Else

   'hier wird Imax * 1s=10s lang gewartet, bis die Spannung
   'an Kondensatoren > U_min1  und < Umin2
   I_max = 10
   For I = 1 To I_max                             'alle 500ms
      Wait 1

      U_batt = Get_u_batt()                       'Batteriespannung messen
      Locate 2 , 1
      Z = Fusing(u_batt , "##.##")
      Lcd "*   Batterie:" ; Z ; "  " ; I
      Locate 2 , 24 : Lcd "*"

      'Wenn die Spannung im richtigen Spannungsbereich liegt,
      'dann Relais einschalten
      If U_batt > U_min1 And U_batt < U_min2 Then 'Spannung zwischen 34.5V und 40.5V (23V-27V)
         Power_on                                 'Relais einschalten
         I = I_max                                'beenden
      End If

      If Power_relais = 0 And I = I_max Then      'Versorgungsspannung falsch und Warteschleife fertig
         Cls
         Lcd "Parameter U_batt0 falsch"
         Beep 6
         Wait 10
         Call Update_parameters                   'U_min neu eunstellen
      End If

   Next I
End If

'---------------- End Show Start Screen ----------------------------------------

Dt = 0.01                                         'feste Zeitdifferenz zwischen 2 Messungen (10ms)
Phi_alt = 0
Pwm_alt = 0
Lenkung_alt = 0
Brems_phi = 0                                     'fr sptere Geschwindigkeitsbegrenzung
U_min = 40                                        'Wird spter auf minimal auftretende Spannung reduziert
Trip_faktor = Int0_way / 100000                   'fr Weg-
Speed_faktor = Trip_faktor * 3600                 'und Geschwindigkeitsberechnng
Way_count_alt = Way_count                         'fr Geschwindigkeitsmessungen
Way_count_alt_2 = Way_count                       'fr Tagesstrecke merken

Timeout = 0                                       'Zeitzhler fr Timeout

'3c---------------- Ausfhrung des Testmodus prfen ----------------------------

If Test_modus = 0 Then                            'JP7.1= GND; Testmodus aktiviert
   Beep 3
   Wait 1
   Call Runnerboard_test
   Power_off                                      'Runner ausschalten
   Do : Loop
End If

Call Beep(1)

'3d------------------ Test foot switches 4 times and ---------------------------
Locate 1 , 1
Lcd "* Press foot switch 4x *"
Locate 2 , 1
For J = 1 To 4                                    'test 4 switches
   I = 0
   Do
      If Run_switch = 0 Then                      'Fuschalter
         Incr I                                   'Zeitzhler fr Bettigungsdauer in ms
         Timeout = 1
      Else
         Incr Timeout                             'kein Fuschalter gedrckt
         I = 0
      End If

      Mod_timeout = Timeout Mod 1000 : If Mod_timeout = 0 Then Lcd "*"

      Waitms 1

      If Timeout > 24000 Then                     'Run_switch not pressed for 24000*1ms = 24s
         Power_off                                'switch power off
      End If
   Loop Until I > 200                             'Run_switch pressed more than 200ms
   Locate 2 , 1
   Lcd "*      No.: " ; J ; " ok        *"
   Locate 2 , 1
   Beep 1
   Do : Loop Until Run_switch = 1                 'Wait until Run_switch is open (off)
Next J

'3e------------------ Prfung und Erneuern Sensor-Offsetwerte --------------------
'Falls beim letzten Einschalten ein Fehler vorlag, ist Error_e > 0
Error = Error_e                                   'read last Error from ERAM

If Error > 0 Then                                 'Fehler, Sensor-Offsetwerte neu einlesen
   Cls
   Lcd "***  ERROR=" ; Error ; " ***"
   Call Beep(6)

   Call Calculate_offsets                         'neue Offsetwerte berechnen

   Error_e = 0                                    'Delete error number

   Locate 2 , 1
   Power_off                                      'Relais ausschalten
   Cls : Lcd "*Restart Runner*"
   Call Beep(3)
   Wait 1
   Do : Loop
End If


'*******************************************************************************
'04                Check all Sensor Offsets                                    *
'*******************************************************************************
Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)       'Read Sensor first

'------------------ Prfung der Sensorwerte ------------------------------------
Phi = Calculate_phi()                             'Winkel = Abweichung von der Ruhelage feststellen
If Phi < -0.2 Or Phi > 0.2 Then
   Error = 1                                      'Anfangsneigung im unzulssigen Bereich 0  11.5
End If

'------------------ Prfen des Gyrosensors -------------------------------------
Phi_rate = Calculate_phi_rate()                   'Phi_rate

If Phi_rate < -20 Or Phi_rate > 20 Then
   Error = Error + 2
End If

'------------------ Prfen des Giersensors -------------------------------------
Gier = Calculate_gier()

If Gier < -20 Or Gier > 20 Then
   Error = Error + 4
End If

'------------------ Prfen der Lenkungstellung ---------------------------------
Adc5 = Getadc(5)                                  'Lenkungswert einlesen
Lenkung = Adc5 - Lenkung_0                        'Offsetwert subtrahieren
If Lenkung < -30 Or Lenkung > 30 Then
   Error = Error + 8
End If

'------------------ Prfen der Seitenneigung -----------------------------------
Acz = Acz - Acz_0
Acz = Abs(acz)
If Acz > 300 Then
   Error = Error + 16
End If

Error_e = Error                                   'Fehler im ERAM speichern

'*******************************************************************************
'05                Fehlerauswertung und Ausgabe                                *
'*******************************************************************************
Timeout = 0
If Error < 2 Then                                 'Error=1 nur Neigungsfehler beim Einschalten oder Error=0
   Do
      Incr Timeout                                '1 x pro Sekunde erhhen und warten bis Timeout=30
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)       'Read Sensor first                                       'Warten - prfen, ob senkrechter Stand am Anfang
      Phi = Calculate_phi()                       'Winkel=Abweichung von der Ruhelage feststellen
      Call Beep(1)
      Cls : Lcd "*      Plattform      *"
      Locate 2 , 1 : Lcd "*  waagerecht stellen  *"
      Wait 1

      If Timeout > 30 Then                        'nach 30s Fehlermeldung auf das Display
         Lcd "Neigungssensor prfen"
         Locate 2 , 1
         Lcd "*********************"
         Call Beep(6)                             '6 x piepen
         Power_off                                '... und ausschalten
      End If

   Loop Until Phi > -0.15 And Phi < 0.15          'Anfangsneigung im zulssigen Bereich 0  11.5
   Error = 0
   Error_e = Error                                'Fehler lschen, alles ok
   Enable Interrupts                              'Runner normal starten
Else
   Call Beep(6)
   Cls
   Lcd "*   SensorError: " ; Error ; "     *"
   Locate 2 , 1
   Lcd "*Restart Runner*"
   Power_off                                      'Relais ausschalten
   Do
      Call Beep(1)
      Wait 1
   Loop
End If
'--------------------------- Grundeinstellungen fertig -------------------------

'*******************************************************************************
'06                 Hauptschleife fr LCD-Ausgabe                              *
'*******************************************************************************
'-------------------- Ausgabemodi fr LCD --------------------------------------
'  Display_mode = 0 'keine LCD-Ausgabe
'  Display_mode = 1 'Ausgabe der Sensorwerte und Testwerte bei Bedarf
'  Display_mode = 2 'Ausgabe der PWMwerte
'  Display_mode = 3 'Normalausgabe mit Ausgabe des Auslastungsindex
'  Display_mode = 4 'Kontrollausgabe des Winkel und Gier
'  Display_mode = 5 'Ausgabe von Overspeed
'  Display_mode = 6 '
'  Display_mode = 7 'Normalausgabe mit Stromstrke auf 24x2 LCD

Cls
'------------------ Check Battery ----------------------------------------------
U_batt = Get_u_batt()                             'Batteriespannung messen

If U_batt > U_min2 Then                           '> U_batt0 * 1.1 = 41.25V bei 37.5V
   Batterie_kap = Batterie_kap0                   'Batterie als neu geladen erkannt
   Batterie_kap_e = Batterie_kap                  'Ladungszustand der Batterie speichern
End If

Display_count = 0                                 'Togglebyte fr wechselnde Spannungs-/Stromanzeige
Loop_count = 80                                   'vorbesetzt, damit die LCD-Ausgabe schnell erscheint

Enable Timer2                                     'start 10ms interrupt

'------------------ Main-Loop and Display output -------------------------------
Do                                                'Hauptschleife und LCD-Ausgabe
   Incr Freilauf                                  'Freilaufzyklen werden gezhlt
   If Loop_count = 100 Then                       'Lcd -ausgabe Nach Jeder Sekunde Bei Loop_count = 100

      Loop_count = 0                              'Zhler fr Sekundentakt zurcksetzen

      'Stromwerte zwischenspeichern, Adc7 wird im Interrupt ausgelesen und aufaddiert
      Adc7_temp = Adc7 / 100                      'Mittelwert in einer Sekunde aus der Interruptroutine
      Adc7 = 0                                    'Stromsumme zurcksetzen

      Adc0 = Getadc(0)                            'U_batt fr sptere Displayausgabe auslesen

      'Store Way_Count for calculating speed
      Way_count_temp = Way_count                  'Wegzhler auslesen

      'calculating speed (km/h)
      Way_count_diff = Way_count_temp - Way_count_alt       'Differenz pro Sekunde
      Way_count_alt = Way_count_temp              'letzten Wert zur Geschwindigkeitsbestimmung merken

      Km_speed = Way_count_diff                   'Convert DWord->single
      Km_speed = Km_speed * Speed_faktor

      If Km_speed > Km_speed_max Then
         Km_speed_max = Km_speed                  'remember maximum speed for display
      End If

      'Overspeed = Km_speed - V_max                'disabled at the moment, Differenz zur Max-Geschwindigkeit feststellen

      Select Case Display_mode

         Case 1:                                  'Kontrollausgaben

            Locate 1 , 6
            Lcd Acz_0 ; "       "
            Locate 1 , 14
            Lcd Acz ; "     "

         Case 2:                                  'Kontrollausgaben
            Locate 1 , 1
            Lcd "PWM=" ; Pwm ; "          "
            Locate 1 , 9 : Lcd " L=" ; Lenkung ; "         "
            Locate 2 , 1 : Lcd "L=" ; Motor_pwm_l ; "   ";
            Locate 2 , 9 : Lcd " R=" ; Motor_pwm_r ; "             ";

         Case 3:                                  'Ausgabe mit Loop_count_index
            Z = Fusing(km_speed , "##.##")
            Locate 1 , 1 : Lcd Z ; "km/h   "

            Z = Fusing(km_speed_max , "##.##")
            Locate 1 , 12 : Lcd Z ; "   "

            'Ausgabe der Wegstrecke
            If Run = 1 Then                       'Tages-Wegstrecke ausgeben
               Way_count_diff = Way_count_temp - Way_count_alt_2
               Trip = Way_count_diff              'Typkonvertierung
            Else
               Trip = Way_count_temp              'single <== Dword
            End If

            Trip = Trip * Trip_faktor             'Trip_faktor  '=0.0000224074
            Z = Fusing(trip , "###.###")

            Locate 2 , 1 : Lcd Z ; "km   "

            'Ausgabe der Batteriespannung
            U_batt = Get_u_batt()                 'Batteriespannung messen
            If U_batt < U_min Then
               U_min = U_batt
            End If

            'Ausgabe der Mindestspannung

            If Display_count = 2 Then
               U_batt = U_min                     'Es wird im Wechsel U_batt und U_min ausgegeben
               Display_count = 0                  'Zurcksetzen
            End If

            Z = Fusing(u_batt , "##.#")
            Locate 2 , 11 : Lcd Z ; "V   "

            'Ausgabe der Stromstrke
            Strom_wert = Adc7_temp - 121          'Offset subtrahieren
            Strom_wert = Strom_wert / 12.276      'Stromstrke berechnen
            Z = Fusing(strom_wert , "##.#")       'Mittelwert aus der letzten Sekunde
            Locate 1 , 18 : Lcd Z ; "A   "

            Temp = Strom_wert

            If Temp > 1 Then
               'Umrechnung des Stromes nach Peukert
               Temp = Log(temp)
               Temp = Temp + 0.356675             '+log(H/C)=log(20/14)=0.356675
               Temp = Temp * 0.2                  'Multiplikation mit x=k-1
               Temp = Strom_wert * Exp(temp)      'Anwendung der e-Funktion
            End If

            Temp = Temp / 3600                    'Strommessung pro Sekunde auf Ah umrechnen
            Batterie_kap = Batterie_kap - Temp    'restliche Batterieladung
            Z = Fusing(batterie_kap , "##.#")

            'Freilaufzyklen werden gezhlt,
            Freilauf = Freilauf / Freeloop_ref    'Ergebnis in %
            Auslastung = 100 - Freilauf           'Auslastung = 100 - Freilauf (in%)

            Locate 2 , 18 : Lcd "CPU " ; Auslastung ; "%  "
            Freilauf = 0


         Case 4:                                  'Kontrollausgabe des Neigungswinkels

            Z_single = Rad2deg(phi)               'In Grad umrechnen
            Z = Fusing(z_single , "##.##")
            Locate 1 , 1 : Lcd "Phi=" ; Z ; "  "  'Ausgabe des Neigungswinkels zur Kontrolle bei hheren Geschwindigkeiten

            Z_single = Rad2deg(phi_rate)
            Z = Fusing(z_single , "##.##")
            Locate 1 , 11 : Lcd "Phi_R=" ; Z      'Ausgabe des Neigungswinkels zur Kontrolle bei hheren Geschwindigkeiten

            Locate 2 , 1
            Lcd "  Gier=" ; Gier ; "      "


         Case 5:                                  'Kontrollaugabe der Geschwindigkeitsbegrenzung

            Z = Fusing(km_speed , "##.##")        '* 12.3km/h  18.1*
            Locate 1 , 1 : Lcd "* " ; Z ; "km/h "

            Z = Fusing(km_speed_max , "##.##")
            Lcd Z ; "*"

            Locate 2 , 1
            Z = Fusing(overspeed , "##.##")
            Lcd Z ;
            Locate 2 , 8
            Z = Fusing(overspeed_integral , "##.##")
            Lcd Z ;
            Locate 2 , 16
            Z = Fusing(integral , "##.##")
            Lcd Z ;                               'Integralwert von PID-Filter

         Case 7:                                  'Normalausabe

            Z = Fusing(km_speed , "##.##")
            Locate 1 , 1 : Lcd Z ; "km/h   "

            Z = Fusing(km_speed_max , "##.##")
            Locate 1 , 12 : Lcd Z ; "   "

            'Ausgabe der Wegstrecke                                                                9
            If Run = 1 Then                       'Tages-Wegstrecke ausgeben
               Way_count_diff = Way_count_temp - Way_count_alt_2
               Trip = Way_count_diff              'Typkonvertierung
            Else
               Trip = Way_count_temp              'single <== Dword
            End If

            Trip = Trip * Trip_faktor             'Trip_faktor  '=0.0000224074
            Z = Fusing(trip , "###.###")

            Locate 2 , 1 : Lcd Z ; "km   "

            'Ausgabe der aktuellen Batteriespannung
            U_batt = Get_u_batt()                 'Batteriespannung messen
            If U_batt < U_min Then
               U_min = U_batt
            End If

            'Abwechselnde Ausgabe von U_batt und U_min (Mindestspannung)
            Incr Display_count
            If Display_count = 2 Then
               U_batt = U_min                     'Es wird im Wechsel U_batt und U_min ausgegeben
               Display_count = 0                  'Zurcksetzen
            End If

            Z = Fusing(u_batt , "##.#")
            Locate 2 , 11 : Lcd Z ; "V   "

            'Ausgabe der Stromstrke
            Strom_wert = Adc7_temp - 121          'Offset subtrahieren
            Strom_wert = Strom_wert / 12.276      'Stromstrke berechnen
            Z = Fusing(strom_wert , "##.#")       'Mittelwert aus der letzten Sekunde
            Locate 1 , 18 : Lcd Z ; "A   "

            Temp = Strom_wert

            If Temp > 1 Then
               'Umrechnung des Stromes nach Peukert
               Temp = Log(temp)
               Temp = Temp + 0.356675             '+log(H/C)=log(20/14)=0.356675
               Temp = Temp * 0.2                  'Multiplikation mit x=k-1
               Temp = Strom_wert * Exp(temp)      'Anwendung der e-Funktion
            End If

            Temp = Temp / 3600                    'Strommessung pro Sekunde auf Ah umrechnen
            Batterie_kap = Batterie_kap - Temp    'restliche Batterieladung
            Z = Fusing(batterie_kap , "##.#")
            Locate 2 , 18 : Lcd Z ; "Ah   "

      End Select

   End If
Loop
End

'*******************************************************************************
'10                Interruptregelung alle 10ms                                 *
'*******************************************************************************
Calculate_balance:

   Timer2 = Timer2_load                           'Timer2 neu laden fr Interrupt nach 10ms

   If Test_modus = 0 Then                         'JP7.1= GND; Testmodus aktiviert

      '============ Ausgaben fr Testmode =========================================
      '============================================================================

      Incr Loop_count

      Run = 1 - Run_switch                        'Motorsteuerung durch Fuschalter aktivieren, RUN_Switch schaltet gegen Masse'0'

      If Run = 0 Then                             'Fuschalter nicht gedrckt
         Incr Timeout
         If Timeout > 30000 Then                  'nach 5 min ausschalten
            Musik
            Power_off
            Do : Loop
         End If
      Else
         Timeout = 0
      End If

      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)

      Phi = Calculate_phi()
      Phi = Rad2deg(phi)

      Help = Abs(phi)                             'Ausschalten bei starker Neigung
      If Help > 30 Then
         Power_off                                'Relais ausschalten
         Do
            Lcd "*"
            Waitms 10
            Beep 1
         Loop
      End If

      Phi = Simple_filter(phi_alt , Phi , 0.01)

      Phi_alt = Phi

      Pwm = Phi * 5.0                             'Anpassung an PWM

      '------------------ Berechnung der Motor-PWM-Werte --------------------------
      Adc5 = Getadc(5)                            'Lenkung einlesen
      Lenkung = Adc5 - Lenkung_0
      Lenkung = Lenkung / 10.0                    'Lenkwert anpassen

      Motor_pwm_r = Pwm + Lenkung
      Motor_pwm_r = Motor_pwm_r * Pwm_faktor

      Motor_pwm_l = Pwm - Lenkung
      Motor_pwm_l = Motor_pwm_l * Pwm_faktor

      If Run = 0 Then
         Motor_pwm_l = 0                          'alle Motoren aus
         Motor_pwm_r = 0
      End If

      '---------------------- Ausgabe der PWM-Werte -------------------------------
      'rechter Motor
      If Motor_pwm_r > 0 Then                     'Richtungen festlegen
         Pwm_dir_r = 1
      Else
         Pwm_dir_r = 0
         Motor_pwm_r = -1 * Motor_pwm_r           'Vorzeichen wechseln
      End If

      If Motor_pwm_r > Pwm_max Then Motor_pwm_r = Pwm_max       'Maximalwert=500

      Pwm_word_r = Motor_pwm_r                    'nach Word konvertieren

      Pwm1a = Pwm_word_r                          'PWM_Werte ausgeben

      'linker Motor
      If Motor_pwm_l > 0 Then                     'Richtungen festlegen
         Pwm_dir_l = 1
      Else
         Pwm_dir_l = 0
         Motor_pwm_l = -1 * Motor_pwm_l           'Vorzeichen wechseln
      End If

      If Motor_pwm_l > Pwm_max Then Motor_pwm_l = Pwm_max       'Maximalwert=500

      Pwm_word_l = Motor_pwm_l                    'nach Word konvertieren

      Pwm1b = Pwm_word_l

      '============ Ende der Ausgaben fr Testmode ================================
      '============================================================================

   Else                                           'Normalbetrieb -kein Testmode

      '============ Ausgaben fr Normalbetrieb ====================================
      '============================================================================

      Enable Interrupts                           'damit im INT0 weiter die Geschwindigkeit gemessen werden kann

      Incr Loop_count                             'Bei Loop_count=100 erfolgt LDC-Ausgabe 1x pro Sekunde

      If Loop_count = 20 Or Loop_count = 40 Or Loop_count = 60 Or Loop_count = 80 Or Loop_count = 100 Then
         Toggle Irq_led_pin
      End If


      'Maximalwerte festhalten
      'If Pwm > Pwm_high Then Pwm_high = Pwm  ' erfolgt direkt nach der PWM-Berechnung
      If Strom_wert > Strom_max Then Strom_max = Strom_wert
      V_max = Km_speed_max
      If Phi > Phi_max Then Phi_max = Phi


      '10a -------------- Strom- Spannung- Ladungsmessung -------------------------
      Adc7 = Adc7 + Getadc(7)                     'Stromsumme (Mittelwert) fr 1 Sekunde bilden

      Run_alt = Run                               'vorherige Stellung des Fuschalters speichern
      Run = 1 - Run_switch                        'Motorsteuerung durch Fuschalter aktivieren, RUN_Switch schaltet gegen Masse'0'
      D_run = Run - Run_alt                       'Wechsel feststellen, nach dem Einschalten D_run=1
      'nach dem Ausschalten D_run=-1 (=255=$FF, da Byte)


      If D_run > 127 Then                         'wenn Fuschalter ausgeschaltet wurde,(D_run_Byte=255=-1)

         If Way_count > 0 Then
            Way_count_e = Way_count               'Gesamtweg im ERAM speichern, 0 vermeiden
         End If

         Batterie_kap_e = Batterie_kap            'aktuellen Ladungszustand der Batterie speichern

         'Maximalwerte der letzten Fahrt im EROM speichern
         Pwm_high_e = Pwm_high
         Strom_max_e = Strom_max
         V_max_e = V_max
         Phi_max_e = Phi_max

      End If

      '10c ------------------- Geschwindigkeitsbegrenzung -------------------------
      '----------------------------- nicht aktiv ! --------------------------------

      '-------------------- Acc- und Gyro-Sensor auslesen -------------------------
      '
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      '

      '10d ----------- Neigungswinkel berechnen und filtern -----------------------

      Phi = Calculate_phi()                       'Phi einlesen und umrechnen in rad

      Phi_rate = Calculate_phi_rate()             'Phi_rate einlesen und umrechnen in rad

      Acz = Acz - Acz_0                           'Rechts-Links-Sensorwert minus Offset
      Acz = Abs(acz)                              'Betrag bilden

      '10e ---------- Ausschalten wegen zu starker Neigung ------------------------
      If Run_count > 0 Then
         Decr Run_count                           'verzgertes Abschalten des PWM-Signals wenn Run_count=0 erreicht
      End If

      If Run = 1 Then
         Run_count = 200                          'fr verzgertes Abschalten von PWM bei Run=1 verhindern
         Timeout = 0                              'Zeitzhler fr automatisches Ausschalten lschen
      End If

      If Run = 0 And Run_count = 0 Then           'verzgerte Notabschaltung nur bei Run=0, d.h. nicht whrend der Fahrt
         '0.4rad=23 Neigung zu stark oder Seitenneigung >~70 (Acz >4000) ==> ausschalten
         If Phi < -0.4 Or Phi > 0.4 Or Acz > 3500 Then
            Disable Interrupts
            Pwm1a = 0
            Pwm1b = 0
            Power_off

            For I = 1 To 3                        'mehrfaches Piepen
               Call Beep(3)
               Waitms 100
            Next I

            Do : Loop
         End If
      End If


      '10f ---------- Komplementr Filter ------------------------------------------
      'Phi_filter=(1-b)*Phi_neu + b*dt*w + b*Phi_alt     (gefilterter Phi_wert)
      'B_1 = (1-b)
      Help1 = B_1 * Phi                           ' = (1-b)*Phi_neu

      Help2 = Filter_komp * Phi_rate              ' = b*dt*w
      Help2 = Help2 * Dt

      Help3 = Filter_komp * Phi_alt               ' = b*Phi_alt

      Phi = Help1 + Help2
      Phi = Phi + Help3                           ' = gefilterter Phi_wert
      Phi_alt = Phi                               ' Phi_alt sichern

      '----------------------------------------------------------------------------

      Help = Abs(phi)

      If Help < 0.02 Then
         Neigung_led = 1                          'LED-Anzeige fr "Senkrecht stehend" +-0.02
      Else
         Neigung_led = 0
      End If

      '10g ----------- Gier aus Gyro(x,y) berechnen und filtern -------------------
      Gier = Calculate_gier()
      Gier = Gier_faktor * Gier
      Gier = Simple_filter(gier_alt , Gier , Filter_gier)
      Gier_alt = Gier

      '10h ------------- Lenkungswert einlesen und filtern ------------------------
      Adc5 = Getadc(5)                            'get steering value
      Lenkung = Adc5 - Lenkung_0                  'remove offset
      Lenkung = Lenkung * Lenk_faktor
      Lenkung = Simple_filter(lenkung_alt , Lenkung , Filter_lenkung)
      Lenkung_alt = Lenkung

      '10i --------- ABS(Lenkungswert) berechnen und Mitte anzeigen ---------------
      Help = Abs(lenkung)
      If Help < 10 Then
         Lenkung_led = 1                          'Mittelstellung  9
      Else
         Lenkung_led = 0
      End If

      Lenkung = Lenkung + Gier                    'Gier-Korrektur

      '10j ---------------- Berechnung der Beschleunigung -------------------------


      '------- Integralwert zum PID-Filter ------
      Integral = Integral + Phi


      '*** Die Beschleunigung geschwindigkeitsabhngig vergrern
      '*** Dynamische Beschleunigung zur Verbesserung der Balance bei hheren
      '*** Geschwindigkeiten Km_speed
      '*** km_speed steht 1 Mal pro Sekunde aus der Displayroutine zur Verfgung.
      '*** Ein proportional zur Geschwindigkeit vergrerter Beschleunigungswert
      '*** erhht die Stabilitt bei hheren Geschwindigkeiten.

      Help = Km_speed / Ref_speed_a               'for dymanic balance
      Help = Help + 1
      Phi = Phi * Help                            '*(1 + km_speed/ref_speed_a)

      Beschleunigung = A * Phi

      Help = Km_speed / Ref_speed_b               'for dymanic balance
      Help = Help + 1
      Phi_rate = Phi_rate * Help                  '*(1 + km_speed/ref_speed_b)

      Help = B * Phi_rate

      Beschleunigung = Beschleunigung + Help      'Bestimmung der Beschleunigung

      Help = C * Beschleunigung                   'Berechnung der neuen Geschwindigkeit
      Help = Help * Dt
      Speed = Speed + Help

      Pwm = Speed + Beschleunigung                'Hier noch 0 < Pwm < 1

      Help = D * Integral
      Pwm = Pwm + Help                            ' D*Integralwert zu PWM addieren


      '10k ----------- Zu Beginn den Pwm_Faktor langsam ansteigen lassen ----------
      '10b ---------- Automatisches Ausschalten nach 5 min ------------------------


      If Run = 1 Then                             'wenn Fuschalter gedrckt,dann

         If Pwm_faktor < Pwm_faktor_max Then      'langsames Ansteigen des PWM-Faktors
            Pwm_faktor = Pwm_faktor + 3           'Anstieg in (Pwm_faktor_max/2) * 10ms = 1,75s
         End If

      Else                                        'bei Run=0
         Incr Timeout                             'Zeitzhler fr automatisches Ausschalten erhhen
         If Timeout > 30000 Then                  'nach 30000*0.01s = 5 Minuten ...
            Disable Interrupts                    'alles ausschalten
            Cls
            Lcd "* Automatisches*"
            Locate 2 , 1 : Lcd "* Ausschalten *"
            Call Musik
            Power_off                             'Relais nach 5 min ausschalten
            Do : Loop                             'und bis die Spannung abgefallen ist hier warten
         End If

         'Wenn Fuschalter ausgeschaltet ist
         If Pwm_faktor > 3 Then                   'whrend der Fahrt ist Pwm_faktor=350
            Pwm_faktor = Pwm_faktor - 3           'langsames reduzieren des PWM-Faktors, ca. 1.75s
         End If

         If Run_count < 3 Then                    'bei Run = 0 wird Run_count decrementiert
            Beschleunigung = 0                    '... nach 2 Sec verzgert alles ausschalten
            Speed = 0
            Pwm = 0
            Lenkung = 0
            Integral = 0                          'Integralwert des PID-Filter zurcksetzen
         End If
      End If

      '10L ----------- Berechnung der Motor-PWM-Werte -----------------------------
      Lenkung = Lenkung / Pwm_faktor_max          'Anpassung wegen spterer Multiplikation

      Motor_pwm_r = Pwm + Lenkung
      Motor_pwm_r = Motor_pwm_r * Pwm_faktor

      Motor_pwm_l = Pwm - Lenkung
      Motor_pwm_l = Motor_pwm_l * Pwm_faktor

      Pwm = Pwm * Pwm_faktor
      'Maximalwerte festhalten
      If Pwm > Pwm_high Then Pwm_high = Pwm


      '10m ----------- Ausgabe der PWM-Werte --------------------------------------
      'rechter Motor
      If Motor_pwm_r > 0 Then                     'Richtungen festlegen
         Pwm_dir_r = 1
      Else
         Pwm_dir_r = 0
         Motor_pwm_r = -1 * Motor_pwm_r           'Vorzeichen wechseln
      End If

      If Motor_pwm_r > Pwm_max Then
         Motor_pwm_r = Pwm_max                    'Maximalwert=500
      End If

      Pwm_word_r = Motor_pwm_r                    'nach Word konvertieren

      If Run_count < 3 Then                       'bei Run = 0 wird Run_count decrementiert
         Pwm1a = 0                                'PWM_Wert lschen
      Else
         Pwm1a = Pwm_word_r                       'PWM_Werte ausgeben
      End If


      'linker Motor
      If Motor_pwm_l > 0 Then                     'Richtungen festlegen
         Pwm_dir_l = 1
      Else
         Pwm_dir_l = 0
         Motor_pwm_l = -1 * Motor_pwm_l           'Vorzeichen wechseln
      End If

      If Motor_pwm_l > Pwm_max Then
         Motor_pwm_l = Pwm_max                    'Maximalwert=500
      End If

      Pwm_word_l = Motor_pwm_l                    'nach Word konvertieren

      If Run_count < 3 Then                       'bei Run = 0 wird Run_count decrementiert
         Pwm1b = 0                                'PWM_Wert lschen
      Else
         Pwm1b = Pwm_word_l                       'PWM_Werte ausgeben
      End If

   End If

Return
'------------------ Ende Regelinterrupt Calculate_balance ----------------------

'*******************************************************************************
'20                Interrupt fr Weg- und Geschwindigkeitsmessung              *
'*******************************************************************************
Incr_way_count:

   $asm                                           'mit neuer Adressierung

      push R24                                    'Register retten
      In r24,sreg                                 'Statusregister einlesen und
      push r24                                    'auf den Stack schieben

      lds R24,{way_count}                         'Byte_1 erhhen
      inc R24
      sts {way_count},R24                         'zurck schreiben
      brne Fertig

      lds R24,{way_count+1}                       'Byte_2 erhhen
      inc R24
      sts {way_count+1} ,R24                      'zurck schreiben
      brne Fertig

      lds R24,{way_count+2}                       'Byte_3 erhhen
      inc R24
      sts {way_count+2},R24                       'zurck schreiben
      brne Fertig

      lds R24,{way_count+3}                       'Byte_4 erhhen
      inc R24
      sts {way_count+3},R24                       'zurck schreiben

Fertig:
      Pop R24                                     'Statusregister zurck holen
      Out Sreg , R24                              '... und zurckschreiben
      pop R24                                     'Register zurck holen
   $end Asm


Return

'*******************************************************************************
'21                 Initialisiere Sensoren, Offset berechnen                   *
'*******************************************************************************
Sub Calculate_offsets
   Cls
   Lcd "*Get new offset values!*"
   Locate 2 , 1
   Lcd "*      Do not move     *"
   Call Beep(3)
   Wait 2
   Cls
   Lcd "*     Press Button     *"
   Do : Loop Until Run_switch = 0
   Call Beep(1)
   Do : Loop Until Run_switch = 1                 'Warten bis Knopf losgelassen
   Call Beep(1)
   Wait 2

   '21a------------ Neigungswinkel Offset einstellen ---------------------------
   Phi_0 = 0                                      'wird in Calculate_phi() benutzt, zum Justieren vorher=0 setzen
   Help = 0
   For I = 1 To 16
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      Phi = Calculate_phi()
      Help = Help + Phi
      Waitms 20
   Next I

   Phi_0 = Help / 16                              'Mittelwert
   Phi_0_e = Phi_0                                'neuen Offsetwert im ERAM speichern

   Locate 2 , 1 : Lcd "Phi_0=   " ; Phi_0 ; "     "
   Call Beep(1)
   Wait 2

   '21b------------ Gyrosensor Offset einstellen -------------------------------

   Phi_rate_0 = 0
   Help = 0

   For I = 1 To 16
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      Phi_rate = Calculate_phi_rate()
      Help = Help + Phi_rate
      Waitms 20
   Next I

   Phi_rate_0 = Help / 16                         'Mittelwert
   Phi_rate_0_e = Phi_rate_0                      'neuen Offsetwert im ERAM speichern

   Locate 2 , 1 : Lcd "Phi_rate_0=" ; Phi_rate_0 ; "     "
   Call Beep(1)
   Wait 2

   '21c------------ Giersensor Offset einstellen -------------------------------

   Gier_0 = 0
   Help = 0

   For I = 1 To 16
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      Gier = Calculate_gier()
      Help = Help + Gier
      Waitms 20
   Next I

   Gier_0 = Help / 16                             'Mittelwert
   Gier_0_e = Gier_0                              'neuen Offsetwert im ERAM speichern

   Locate 2 , 1 : Lcd "Gier_0=" : Lcd Gier_0 : Lcd "     "
   Call Beep(1)
   Wait 2

   '21d------------ Acz-Offset (seitliche Neigung) -----------------------------
   Acz_0 = 0
   Help = 0

   For I = 1 To 64
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      Acz_0 = Acz_0 + Acz
      Waitms 20
   Next I

   Acz_0 = Acz_0 / 64                             'Mittelwert
   Acz_0_e = Acz_0                                'neuen Offsetwert im ERAM speichern

   Locate 2 , 1 : Lcd "Acz_0=" : Lcd Acz_0 : Lcd "     "
   Call Beep(1)
   Wait 2

   '21e------------ Lenker-Potentiometer Offset --------------------------------

   Lenkung_0 = 0

   For I = 1 To 16
      Lenkung_0 = Lenkung_0 + Getadc(5)
      Waitms 20
   Next I

   Lenkung_0 = Lenkung_0 / 16                     'Mittelwert
   Lenkung_0_e = Lenkung_0                        'neuen Offsetwert im ERAM speichern

   Locate 2 , 1 : Lcd "Lenkung_0=" ; Lenkung_0 ; "     "
   Call Beep(1)
   Wait 2

End Sub

'*******************************************************************************
'22                 Beep Tne erzeugen                                         *
'*******************************************************************************
Sub Beep(byval Cn As Byte)                        'Anzahl: Cn kurze Beeps
   For I = 1 To Cn
      Sound Beep_pin , 300 , 900
      Waitms 20
   Next I
End Sub

'*******************************************************************************
'23                 Digitaler Simple Filter                                    *
'*******************************************************************************
'Function Simple_Filter(vorherigem Wert, neuem Wert, FilterFaktor)
Function Simple_filter(byval Wa As Single , Byval Wf As Single , Byval Af As Single) As Single

   'Filter = Wa * (1-a) + Wf * a   = Wa + a * (Wf - Wa)

   Wf = Wf - Wa
   Wf = Wf * Af
   Simple_filter = Wa + Wf                        'Returnwert
End Function

'*******************************************************************************
'24                 Startmelodie erzeugen                                      *
'*******************************************************************************
Sub Musik
   Local C1 As Single

   C1 = _xtal / 12                                '=crystal/12

   Restore Musik1

   For I = 1 To 9
      Read T1 : Read F                            'Dauer und Frequenz lesen
      Help = C1 / F
      Pulsdauer = Help                            'Konvertierung nach word
      Help = T1 * F                               'T1 = Dauer des Tones (in Sekunden)
      Tondauer = Help / 16
      Sound Beep_pin , Tondauer , Pulsdauer
      Waitms 20
   Next I
End Sub

'*******************************************************************************
'25                 Neigungswinkel berechnen                                   *
'*******************************************************************************
Function Calculate_phi()
   ' vorher Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp) aufrufen !!
   Local Qx As Single , Qy As Single
   Qx = Acx
   Qy = Acy
   Calculate_phi = Atn2(qx , Qy)
   Calculate_phi = Calculate_phi - Phi_0
End Function

'*******************************************************************************
'26                Kipp- Rotation berechnen                                    *
'*******************************************************************************
Function Calculate_phi_rate()                     'returns a single
   Calculate_phi_rate = Gyz - Gyz_0               'Offsetkorrktur
   'Faktor fr Umrechnung in Grad: 0.061
   'Faktor fr Umrechnung in rad : *3.14159265359/180
   'Zusammen : 0,001064651
   Calculate_phi_rate = Calculate_phi_rate * 0.00106465       'Ergebnis in rad
End Function

'*******************************************************************************
'27                Gier-Rotation berechnen                                     *
'*******************************************************************************
Function Calculate_gier()                         'return a single
   Gier_x = Gyx + 2032                            'damit haben beide Gyros
   Gier_y = Gyy + 2000                            'einen Offset von ca. 2006

   Gier_x = Gier_x * Gier_x                       'schrge Komponenten
   Gier_y = Gier_y * Gier_y                       '... quadrieren und

   Gier_x = Gier_x + Gier_y                       '... Summe und
   Calculate_gier = Sqr(gier_x)                   '...Wurzel
   Calculate_gier = Calculate_gier / 32
   Calculate_gier = Calculate_gier - Gier_0       '-Offset
End Function

'*******************************************************************************
'28                Batteriespannung messen                                     *
'*******************************************************************************
Function Get_u_batt
   Adc0 = Getadc(0)                               'ADC_0 einlesen und
   Get_u_batt = Adc0 * U_batt_faktor              'Batteriespannung berechnen
End Function

'*******************************************************************************
'28                I2C-Bus und Sensor MPU-6050 initialisieren                  *
'*******************************************************************************
Sub Init_mpu()

   '  I2C-Bus Init

   Locate 2 , 1 : Lcd "***  SensorError  ***   "  'Wird spter gelscht

   '--------------- Config Atmega for I2C-Bus, old A/D-Port -----------------------
   Config Sda = Porta.2
   Config Scl = Porta.1
   I2cinit                                        'Atmega fr I2C vorbereiten
   Config I2cdelay = 1                            '-1  'Sonderfall fr high speed I2C
   '
   '--------------- Adresse des MPU-6050 prfen und Init MPU ---------------------
   Adr_write = 208                                'Adressen fr MPU-6050
   Adr_read = 209

   I2cstart                                       'I2C-Bus aktivieren
   Waitus 50
   I2cwbyte Adr_write                             'Adresse prfen / bleibt hngen, wenn der Sensor fehlt
   Locate 2 , 1 : Lcd "***   Sensor ok   ***   "  'SensorError lschen
   Beep 1
   Waitus 50
   I2cstop

   '   MPU6050 Init

   Local Help_byte As Byte

   '--- (107) Power Management 1 ---
   I2cstart                                       'start
   I2cwbyte Adr_write                             'write adress of MPU-6050
   I2cwbyte 107                                   'Register 107 Power Management 1
   I2cwbyte &B00000000                            'No Reset / No Sleep / No Cycle / Temp_Sens: Dis / Clock Source: Z-Gyro
   I2cstop

   '   '--- (25) Sample Rate Divider = 1 ---
   '   I2cstart                                    'start
   '   I2cwbyte Adr_write                             'write adress of MPU-6050
   '   I2cwbyte 25                                    'Register 25 Sample Rate Divider (1..8 kHz)
   '   I2cwbyte &B00000000                            'Divider set to 1   (soll)
   '   I2cstop                                        'stop
   Waitms 1

   '--- (26) DLPF = 42/44 Hz --- / 10Hz / 42Hz
   I2cstart                                       'start
   I2cwbyte Adr_write                             'write adress of MPU-6050
   I2cwbyte 26                                    'Register 26 DLPF_CFG (digital lowpass filter) Configuration

   Help_byte = Filter_mpu6050
   If Help_byte < 1 Or Help_byte > 6 Then         'Parameter prfen nach Umstellung auf "Filter_mpu6050"  V7.31
      Cls
      Lcd "* Parameter Error *"
      Locate 2 , 1
      Lcd "*->Filter_MPU6050 Error*"
      Call Beep(6)
      Wait 3

      Update_parameters                           'Automatisches Parameter-Update

   End If

   I2cwbyte Help_byte                             '&B00000011 - Bits 0..2 = 011 (3) - ACC:44Hz, 4.9ms; Gyro:42Hz, 4.8ms
   'wert Hz  Hz
   '0    260 256
   '1    184 188
   '2     94  98
   '3     44  42
   '4     21  20
   '5     10  10
   '6      5   5
   '7     RESERVED
   I2cstop                                        'stop

   Waitms 1

   'Register 27 Gyro Range
   I2cstart                                       'start
   I2cwbyte Adr_write                             'write adress of MPU-6050
   I2cwbyte 27                                    'Register 27 Gyro Configuration
   I2cwbyte &B00011000                            'Bits 3+4 = '11000' -> Full Range: +/-2000/s
   I2cstop                                        'stop

   Waitms 1

   'Register 28 ACC Range
   I2cstart                                       'start
   I2cwbyte Adr_write                             'write adress of MPU-6050
   I2cwbyte 28                                    'Register 28 ACC Configuration
   I2cwbyte &B00010000                            'Bits 3+4 = "10000" - Full Range: +/-8g / No High Pass Filter
   I2cstop                                        'stop

   Waitms 1

End Sub

'*******************************************************************************
'29                 Sensor MPU-6050 auslesen                                   *
'*******************************************************************************
Sub Read_6050(acc_x As Integer , Acc_y As Integer , Acc_z As Integer , Gyr_x As Integer , Gyr_y As Integer , Gyr_z As Integer , Sens_temp As Integer)

   I2cstart
   I2cwbyte Adr_write
   I2cwbyte 59
   I2crepstart
   I2cwbyte Adr_read

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Acc_x = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Acc_y = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Acc_z = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Sens_temp = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Gyr_x = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Ack
   Gyr_y = Makeint(l_byte , H_byte)

   I2crbyte H_byte , Ack
   I2crbyte L_byte , Nack
   Gyr_z = Makeint(l_byte , H_byte)

   I2cstop

   Temp = Sens_temp / 340
   Temp = Temp + 36.53

End Sub

'*******************************************************************************
'21                 Read Parameters from ERAM and Calculate Check_summe        *
'*******************************************************************************
Sub Read_par_calc_cs(byval Store As Byte)

   Check_summe = 0
   Runner_typ = Runner_typ_e : Check_summe = Check_summe + Runner_typ
   Ref_speed_a = Ref_speed_a_e : Check_summe = Check_summe + Ref_speed_a
   Ref_speed_b = Ref_speed_b_e : Check_summe = Check_summe + Ref_speed_b
   Int0_way = Int0_way_e : Check_summe = Check_summe + Int0_way
   Lenk_faktor = Lenk_faktor_e : Check_summe = Check_summe + Lenk_faktor
   Gier_faktor = Gier_faktor_e : Check_summe = Check_summe + Gier_faktor
   U_batt_faktor = U_batt_faktor_e : Check_summe = Check_summe + U_batt_faktor
   Pwm_mode = Pwm_mode_e : Check_summe = Check_summe + Pwm_mode
   Pwm_max = Pwm_max_e : Check_summe = Check_summe + Pwm_max
   Pwm_faktor_max = Pwm_faktor_max_e : Check_summe = Check_summe + Pwm_faktor_max
   A = A_e : Check_summe = Check_summe + A
   B = B_e : Check_summe = Check_summe + B
   C = C_e : Check_summe = Check_summe + C
   D = D_e : Check_summe = Check_summe + D
   Filter_komp = Filter_komp_e : Check_summe = Check_summe + Filter_komp
   Filter_mpu6050 = Filter_mpu6050_e : Check_summe = Check_summe + Filter_mpu6050
   Filter_gier = Filter_gier_e : Check_summe = Check_summe + Filter_gier
   Filter_lenkung = Filter_lenkung_e : Check_summe = Check_summe + Filter_lenkung
   Display_mode = Display_mode_e : Check_summe = Check_summe + Display_mode
   U_batt0 = U_batt0_e : Check_summe = Check_summe + U_batt0
   Batterie_kap0 = Batterie_kap0_e : Check_summe = Check_summe + Batterie_kap0

   If Store = 1 Then
      Check_summe_e = Check_summe
   End If

End Sub

'*******************************************************************************
'30                  Update Parameters                                         *
'*******************************************************************************
Sub Update_parameters

   Disable Interrupts

   Cls : Lcd "*   Update Parameter   *"

   'Bei ausreichender Batteriespannung Relais einschalten,
   ' sonst Einschalter gedrckt halten

   I = 0

   Do
      Incr I

      U_batt = Get_u_batt()                       'Batteriespannung messen

      Locate 2 , 1
      Z = Fusing(u_batt , "##.##")

      Lcd "U=" ; Z ; "  U_min= " ; U_min1         ' und --> LCD

      If U_batt > U_min1 And U_batt < U_min2 Then 'Spannung zwischen 34.5V und 40.5V (23V-27V)
         Power_on                                 'Relais einschalten
         I = 10                                   'beenden
      End If

      Waitms 300                                  'Warten
   Loop Until I = 10                              'maximal 10 x 300ms = 3s warten

   Wait 1


   Do
      Cls
      Lcd "Select Parameter:"
      Locate 2 , 1
      Lcd "<ESC> to finish"

      Call Getkey

      Select Case Key

         Case 66:
            V_str = "U_batt_faktor"               'key B was pressed
            U_batt_faktor = U_batt_faktor * 10
            Renew U_batt_faktor
            U_batt_faktor = U_batt_faktor / 10
            U_batt_faktor_e = U_batt_faktor       'store new value to ERAM

         Case 68:
            Help = Display_mode                   'convert to single
            V_str = "Display_mode"
            Renew Help                            'key D was pressed
            Display_mode = Help                   'convert to Byte
            Display_mode_e = Display_mode         'store new value to ERAM

         Case 75:
            V_str = "Batt-Kapazitt"              'key K was pressed
            Help = Batterie_kap0_e
            Renew Help
            Batterie_kap0_e = Help                'store new value to ERAM

         Case 82:
            Help = Runner_typ                     'Convert to single
            V_str = "Runner_typ"
            Renew Help                            'key R was pressed
            Runner_typ = Help                     'convert to Byte
            Runner_typ_e = Runner_typ             'store new value to ERAM

         Case 85:
            V_str = "Batteriespannung"
            Renew U_batt0                         'key U was pressed
            U_batt0_e = U_batt0                   'store new value to ERAM

         Case 87:
            V_str = "Int0_way"                    'distance for one speed-interrupt
            Renew Int0_way                        'key W was pressed
            Int0_way_e = Int0_way                 'store new value to ERAM

            Cls
            V_str = "Way_Count"                   'km-Stand neu eingeben
            Help = Way_count * Int0_way
            Help = Help / 100000
            Renew Help
            Help = Help / Int0_way
            Help = Help * 100000                  'Wegstrecke in km umrechnen
            Way_count = Help
            Way_count_e = Way_count               '... und speichern

         Case 201:
            V_str = "Parameter A"                 'key F1 was pressed
            A = A * 100
            Renew A
            A = A / 100
            A_e = A                               'store new value to ERAM

         Case 202:
            V_str = "Parameter B"                 'key F2 was pressed
            B = B * 100
            Renew B
            B = B / 100
            B_e = B

         Case 203:
            V_str = "Parameter C"                 'key F3 was pressed
            Renew C
            C_e = C

         Case 204:
            V_str = "Parameter D"                 'key F4 was pressed
            D = D * 100
            Renew D
            D = D / 100
            D_e = D

         Case 205:
            V_str = "Ref_speed_A"                 'key F5 was pressed
            Renew Ref_speed_a
            Ref_speed_a_e = Ref_speed_a           'store new value to ERAM
            Call Beep(1)

            Cls
            V_str = "Ref_speed_B"
            Renew Ref_speed_b
            Ref_speed_b_e = Ref_speed_b

         Case 206:
            V_str = "Filter_komp"
            Renew Filter_komp                     'key F6 was pressed
            Filter_komp_e = Filter_komp

         Case 207:
            V_str = "Filter_MPU6050"              'key F7 was pressed
            Renew Filter_mpu6050
            Filter_mpu6050_e = Filter_mpu6050

         Case 208:
            V_str = "Lenk_faktor"
            Renew Lenk_faktor                     'key F8 was pressed
            Lenk_faktor_e = Lenk_faktor

            Cls
            V_str = "Filter_lenkung"
            Renew Filter_lenkung
            Filter_lenkung_e = Filter_lenkung

         Case 209:
            V_str = "Gier_faktor"
            Renew Gier_faktor                     'key F9 was pressed
            Gier_faktor_e = Gier_faktor

            Cls
            V_str = "Filter_gier"
            Renew Filter_gier
            Filter_gier_e = Filter_gier

         Case 210:                                'key F10 was pressed
            V_str = "PWM_mode"                    ' PWM_mode
            Help = Pwm_mode                       'Datentyp konvertieren
            Renew Help
            Pwm_mode = Help
            Pwm_mode_e = Pwm_mode

            Pwm_max_e = 500                       '500 max PWM
            Pwm_faktor_max_e = 350                '350 max Faktor

         Case 211:
            V_str = "Pwm_max"                     'key F11 was pressed
            Pwm_max = Pwm_max_e
            Renew Pwm_max
            Pwm_max_e = Pwm_max

         Case 212:
            V_str = "Pwm_faktor_max"              'key F12 was pressed
            Pwm_faktor_max = Pwm_faktor_max_e
            Renew Pwm_faktor_max
            Pwm_faktor_max_e = Pwm_faktor_max

         Case 27:                                 'ESC
            Call Read_par_calc_cs(1)              'Read Parameters from ERAM and calculate and store new check_summe

         Case "O":

            Call Calculate_offsets                'neue Offsetwerte berechnen

         Case "P":
            Call Restore_parameters               'Restore My_Parameters
            Call Read_par_calc_cs(1)              'Read Parameters from ERAM and calculate and store new check_summe
            Cls
            Lcd "Restore old file"
            Locate 2 , 1
            Lcd "   My_Parameters"
            Beep 10

         Case "T"
            Call Runnerboard_test                 'Runnerboard_test aufrufen

      End Select

   Loop Until Key = 27                            'ESC to finish and calculate new check_summe

   Call Beep(1)
   Cls
   Lcd "New parameters set"
   Call Auto_restart
End Sub

'*******************************************************************************
'31                 Sub Getkey from a PS/2 keyboard at Port D                  *
'*******************************************************************************
Sub Getkey                                        'key liefert den ASCII-Code der Taste
   Do
      Key = Getatkbd()
   Loop Until Key <> 0

   If Key > 96 And Key < 123 Then Key = Key - 32  'in Grobuchstaben umwandeln
   If Key > 32 Then Lcd Chr(key)
   Waitms 100
End Sub

'*******************************************************************************
'32                 Renew a parameter                                          *
'*******************************************************************************
Sub Renew(v_val As Single)
   Local In_string As String * 10
   Local String_val As Single

   Cls
   Lcd V_str                                      'show variable name
   Locate 2 , 1

   Lcd "old:" ; Fusing(v_val , "###.###")         'show old value
   Locate 2 , 10
   Lcd "=>"
   Key = 0

   In_string = ""                                 'clear input string

   Do
      Call Getkey                                 'get one character -> key
      In_string = In_string + Chr(key)            'create to a string
   Loop Until Key = 13 Or Len(in_string) = 5      '5 no <RET>

   If Len(in_string) > 1 Then                     'a new value is present

      Call Beep(1)
      String_val = Val(in_string)                 'convert to a single

      Cls
      Lcd "old:" ; Fusing(v_val , "###.###")
      Locate 2 , 1
      Lcd "new:" ; Fusing(string_val , "###.###") ; " Y/N:"

      Call Getkey

      If Key = 89 Then                            'Chr(key) = "Y"
         V_val = String_val
         Call Beep(1)
         Wait 1
      End If

   End If
   Cls
End Sub

'*******************************************************************************
'33                 Auto_Restart                                               *
'*******************************************************************************
Sub Auto_restart
   Locate 2 , 1
   Lcd "** Auto Restart Runner **"

   U_batt = Get_u_batt()                          'Batteriespannung messen

   If U_batt > U_min1 And U_batt < U_min2 Then    'Spannung zwischen 34.5V und 40.5V (23V-27V)
      Quick_restart_e = 1                         'notice Auto_Restart next time
   End If

   Config Watchdog = 64                           'set watchdog = 64ms
   Start Watchdog                                 'to Restart Controller now
End Sub

'*******************************************************************************
'34                          Restore_parameters                                *
'*******************************************************************************
Sub Restore_parameters
   '------------- My Parameters for my Runner ----------------------------------
   '------------- used as safe parameters with Check summe ---------------------

   'Key F1,...,F4
   A_e = 0.15

   'Parameter A
   B_e = 0.15                                     'Parameter B
   C_e = 20                                       'Parameter C
   D_e = 0.1                                      'Parameter D
   Ref_speed_a_e = 20                             'Referenz_speed for parameter A
   Ref_speed_b_e = 20                             'Referenz_speed for parameter B

   'Key F5,...,F8
   Filter_komp_e = 0.98                           'Parameter for filter
   Filter_mpu6050_e = 5.0                         'Parameter for filter
   Filter_lenkung_e = 0.1                         'Parameter for filter
   Filter_gier_e = 0.1                            'Parameter for filter

   'Key F9,...,F12
   Lenk_faktor_e = 5                              'Parameter for stearing
   Gier_faktor_e = 4
   Pwm_mode_e = 1                                 'pwm_frequenz=15.625kHz
   Pwm_max_e = 500                                '500 max PWM
   Pwm_faktor_max_e = 350                         '500 max PWM

   'Key B
   U_batt_faktor_e = 0.0454                       'Calculate voltage from ADC_0

   'Key D
   Display_mode_e = 7

   'Key R
   Runner_typ_e = 25                              'Runner2 with digtal Sensor

   'Key U
   U_batt0_e = 25                                 'normale Batteriespannung

   'Key W
   Int0_way_e = 1.13                              'Distance for one INT0 in cm

   'Key K                                         'Batterie Kapazitt
   Batterie_kap0_e = 14


End Sub Restore_parameters

'*******************************************************************************
'35                Power_off - Relais ausschalten                              *
'                  und Maximalwerte sichern                                    *
'*******************************************************************************
Sub Power_off
   Power_relais = 0
End Sub Power_off

'*******************************************************************************
'36                 Power_on - Relais einschalten                              *
'*******************************************************************************
Sub Power_on
   Power_relais = 1
End Sub Power_on

'*******************************************************************************
'38                       Runnerboard_Test                                     *
'*******************************************************************************
Sub Runnerboard_test

   Dim Led_flag As Eram Byte , Adc_flag As Eram Byte
   Dim I2c_flag As Eram Byte , Gyro_flag As Eram Byte
   Dim Phi_flag As Eram Byte , Poti_flag As Eram Byte
   Dim Z2 As String * 16

   Const Text_ausblenden = "* Avoid test next time?*"

   Cls : Lcd "*   RunnerBoard_Test   *"
   Locate 2 , 1
   Lcd "* Reactivate all tests?*"
   Beep 2

   Help = 0
   For I = 1 To 1000

      If Run_switch = 0 Then
         Incr Help                                ' ... 300*2ms = 600ms Tastendruck

         If Help > 300 Then                       'alle Flags setzen
            Led_flag = 1
            Adc_flag = 1
            I2c_flag = 1
            Poti_flag = 1
            Gyro_flag = 1
            Phi_flag = 1

            Locate 2 , 1 : Lcd "* all tests activated  *"
            Beep 1
            Wait 1
            I = 1000
         End If
      End If
      Waitms 2
   Next I

   '----------------- LED-Test -------------------------------------------------
   Cls

   If Led_flag > 0 Then
      Lcd "*       LED-Test       *"
      Beep 1
      I = 260

      Do
         Irq_led_pin = 1 : Waitms I : Irq_led_pin = 0
         Neigung_led = 1 : Waitms I : Neigung_led = 0
         Lenkung_led = 1 : Waitms I : Lenkung_led = 0
         Neigung_led = 1 : Waitms I : Neigung_led = 0
         I = I - 20                               'Laufschleife beschleunigen
      Loop Until I = 0

      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2
      For I = 1 To 200                            '2 Sekunden Pause
         Waitms 10

         If Run_switch = 0 Then                   'Flag setzen
            Led_flag = 0
            I = 200
            Beep 1
         End If
      Next I
      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
   End If

   '----------------- A/D-Test und VCC-Test ------------------------------------
   '--- AD-Wandler konfigurieren, Uref=5Volt ---
   Cls

   If Adc_flag > 0 Then
      Lcd "*  ADC-U-Batterietest  *"
      Beep 1

      U_batt_faktor = 0.0454

      U_batt = Get_u_batt()                       'Batteriespannung messen

      Z = Fusing(u_batt , "##.##")
      Locate 2 , 1 : Lcd "*  U_batt=" ; Z ; " Volt       "
      Locate 2 , 24 : Lcd "*"
      Wait 1

      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2
      For I = 1 To 300                            '3 Sekunden Pause
         Waitms 10
         If Run_switch = 0 Then                   'Flag setzen
            Adc_flag = 0
            I = 300
            Beep 1
         End If
      Next I

      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
   End If

   '----------------- I2c-Initialisierung --------------------------------------
   Cls

   '--- Adresse des MPU-6050 prfen und Init MPU ---
   I2cstart                                       'I2C-Bus aktivieren
   Waitus 50
   I2cwbyte 208                                   'Adresse prfen
   Waitus 50
   I2cstop

   If I2c_flag > 0 Then
      Lcd "* MPU-6050 Sensor-Test *"
      Beep 1
      Locate 2 , 1
      If Err = 0 Then                             'MPU-6050 vorhanden
         Adr_write = 208
         Adr_read = 209
         Lcd "* MPU-6050 at:" ; Adr_write ; " ok   *"
      Else
         Lcd "*  MPU-6050 Error             *"
         Beep 6
         Wait 5
      End If

      Waitms 30
      Call Init_mpu()
      Waitms 50
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)       'Dummyread
      Waitms 10
      Wait 1

      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2
      For I = 1 To 300                            '2 Sekunden Pause
         Waitms 10
         If Run_switch = 0 Then                   'Flag setzen
            I2c_flag = 0
            I = 300
            Beep 1
         End If
      Next I
      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
      Wait 1
   End If

   '-------------------- Lenkerpoti-Test ---------------------------------------
   Cls : Lcd "*   Lenkerpoti-Test    *"

   '--- Mittelwert bestimmen ---
   Lenkung_0 = 0
   For I = 1 To 16
      Adc5 = Getadc(5)
      Lenkung_0 = Lenkung_0 + Adc5
   Next I
   Lenkung_0 = Lenkung_0 / 16                     'Mittelwert bilden

   While Lenkung_0 < 462 Or Lenkung_0 > 562       'Schlechte Mittelstellung

      '--- Mittelwert neu bestimmen ---
      Lenkung_0 = 0
      For I = 1 To 16
         Adc5 = Getadc(5)
         Lenkung_0 = Lenkung_0 + Adc5
      Next I
      Lenkung_0 = Lenkung_0 / 16                  'Mittelwert bilden

      Locate 2 , 1
      Lcd "*Mitte:" ; Lenkung_0 ; " korrigieren!*"
      Beep 1
      Wait 1
   Wend

   'Manueller Poti-Test
   If Poti_flag > 0 Then
      Beep 1

      Lenkung_0 = Lenkung_0 + 60                  'rechte Grenze festlegen

      Do
         Adc5 = Getadc(5)                         'Potentiometerwert einlesen
         Beep 1
         Locate 2 , 1 : Lcd "* " ; Adc5
         Lcd " Lenker rechts--> *"
         Waitms 100

      Loop Until Adc5 > Lenkung_0                 'und berschreiten
      Wait 1

      Lenkung_0 = Lenkung_0 - 120                 'fr linke Grenze einstellen

      Locate 2 , 1 : Lcd "*                      *"
      Do
         Adc5 = Getadc(5)
         'Potentiometerwert einlesen
         Beep 1
         Locate 2 , 1 : Lcd "* <-- " ; Adc5
         Lcd " Lenker links *"
         Waitms 100
      Loop Until Adc5 < Lenkung_0
      Wait 1

      Lenkung_0 = Lenkung_0 + 60                  'Mittelwert wieder herstellen

      Locate 2 , 1 : Lcd "*                      *"
      Do
         Adc5 = Getadc(5)                         'Potentiometerwert einlesen

         Help = Lenkung_0 - Adc5

         If Help > 2000 Then                      'Vorzeichenfehler wegen Word-Subtraktion
            Help = Adc5 - Lenkung_0
         End If
         Beep 1
         Locate 2 , 1 : Lcd "*-> " ; Adc5 ; " Lenker Mitte <-*"
         Waitms 20
      Loop Until Help < 10

      Beep 1
      Wait 1
      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2

      For I = 1 To 300                            '2 Sekunden Pause
         Waitms 10
         If Run_switch = 0 Then                   'Flag setzen
            Poti_flag = 0
            I = 300
            Beep 1
         End If
      Next I

      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
   End If

   '----------------- Gyro-Funktionstest ----------------------------------------
   Cls
   Gyz_0 = 0
   For I = 1 To 16
      Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
      Gyz_0 = Gyz_0 + Gyz
      Waitms 10
   Next I

   Gyz_0 = Gyz_0 / 16                             'Mittelwert berechnen

   If Gyro_flag > 0 Then
      Lcd "*  Gyro_Funktionstest  *"
      Beep 1
      Do
         Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
         Z = Fusing(gyz_0 , "##.#")
         Locate 2 , 1
         Lcd "* Offset=" ; Z ; "         "
         Gyz = Gyz - Gyz_0
         Z = Str(gyz)
         Locate 2 , 16
         Lcd "Gyro=" ; Z ; "        "
         Locate 2 , 24 : Lcd "*"
         Waitms 500
      Loop Until Run_switch = 0
      Beep 1

      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen

      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2
      For I = 1 To 300                            '2 Sekunden Pause
         Waitms 10
         If Run_switch = 0 Then                   'Flag setzen
            Gyro_flag = 0
            I = 300
            Beep 1
         End If
      Next I
      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
   End If

   '------------------ Neigungswinkel Offset bestimmen -------------------------
   '            Dient auch dem Einstellen des 45-Ruhewinkels

   Cls
   Lcd "*  Phi_Funktionstest   *" : Beep 1

   Do
      Phi_0 = 0
      Help = 0
      For I = 1 To 16
         Call Read_6050(acx , Acy , Acz , Gyx , Gyy , Gyz , Sens_temp)
         Phi = Calculate_phi()                    'Ergebnis in rad
         Help = Help + Phi
         Waitms 10
      Next I

      Phi_0 = Help / 16                           'Mittelwert berechnen

      Help = Rad2deg(phi_0)

      Cls
      Lcd "* Phi_0=" ; Help                       'Winkelausgabe
      Locate 1 , 13
      Lcd " deg       *"

      Beep 1

      If Help > 48 Or Help < 42 Then              'Offsetfehler
         Locate 2 , 1
         Lcd "* Phi_0 Error!         *"
         If Phi_flag = 0 Then Phi_flag = 1
         Beep 2
      End If
      Wait 1
   Loop Until Phi_flag = 0 Or Run_switch = 0

   Beep 1
   Do : Loop Until Run_switch = 1                 'Warten auf Taster loslassen

   If Phi_flag > 0 Then

      Locate 2 , 1 : Lcd Text_ausblenden
      Beep 2

      For I = 1 To 300                            '2 Sekunden Pause
         Waitms 10
         If Run_switch = 0 Then                   'Flag setzen
            Phi_flag = 0
            I = 300
            Beep 1
         End If
      Next I

      Do : Loop Until Run_switch = 1              'Warten auf Taster loslassen
   End If


   '-------------------- PWM-Test mit Loop, IRQ, LCD-Ausgabe -------------------


   'Standardconfiguration mit Config Timer1 fr PWM-Mode=1

   Tccr1a = &B11110010                            'wie Config (mode2)
   Tccr1b = &B00000001                            'wie Config (mode2)
   'PWM mit 9 Bit = 512 Werte                   f=15.5kHz

   Pwm_max = 100                                  'fr U=25V
   If U_batt0 > 30 Then
      Pwm_max = 60                                'fr U=37,5V
   End If


   Pwm_faktor = 5

   Enable Interrupts
   Enable Timer2

   '-------------------- Hauptschleife fr Motor-Testmode ----------------------
   Cls : Lcd "*  Phi-PWM-Motor-Test  *"

   'Standardconfiguration mit Config Timer1
   Tccr1a = &B11110010                            'wie Config (mode2)
   Tccr1b = &B00000001                            'wie Config (mode2)
   'PWM mit 9 Bit = 512 Werte                   f=15.5kHz

   Locate 2 , 1
   Lcd "*      PWM-Mode = 1    *"


   Wait 1 : Cls
   Timer2 = Timer2_load                           'Timer2 vorbereiten

   Loop_count = 98

   '--- Hauptschleife --- Ausgaben auf LCD ---
   Do

      If Loop_count = 100 Then                    'nach je einer Sekunde Werte ausgeben

         Loop_count = 0

         Z = Fusing(phi , "##.##")
         Z2 = Fusing(lenkung , "##.##")
         Locate 1 , 1 : Lcd "Phi=" ; Z ; " Deg   "
         Locate 1 , 17 : Lcd "L=" ; Z2 ; "   "

         Z = Fusing(motor_pwm_l , "##.#")
         Z2 = Fusing(motor_pwm_r , "##.#")
         Locate 2 , 1 : Lcd "PWM_L=" ; Z ; "   "
         Locate 2 , 14 : Lcd "PWM_R=" ; Z2 ; "   "

      End If
   Loop

   End

End Sub

'*******************************************************************************
'40                 Convert Keyboard code to ASCII code                        *
'*******************************************************************************

Tabelle:
   'ordnet dem ScannCode der Tastatur einen ASCII-Wert zu
   'normal keys lower case  , y und z fr deutsche Tastatur
   Data 0 , 209 , 0 , 205 , 203 , 201 , 202 , 212 , 0 , 210 , 208 , 206 , 204 , 0 , &H5E , 0
   Data 0 , 0 , 0 , 0 , 0 , 113 , 49 , 0 , 0 , 0 , 121 , 115 , 97 , 119 , 50 , 0
   Data 0 , 99 , 120 , 100 , 101 , 52 , 51 , 0 , 0 , 32 , 118 , 102 , 116 , 114 , 53 , 0
   Data 0 , 110 , 98 , 104 , 103 , 122 , 54 , 7 , 8 , 44 , 109 , 106 , 117 , 55 , 56 , 0
   Data 0 , 44 , 107 , 105 , 111 , 48 , 57 , 0 , 0 , 46 , 45 , 108 , 59 , 112 , 43 , 0
   Data 0 , 0 , 0 , 0 , 0 , 92 , 0 , 0 , 0 , 0 , 13 , 0 , 0 , 92 , 0 , 0
   Data 0 , 60 , 0 , 0 , 0 , 0 , 8 , 0 , 0 , 49 , 0 , 52 , 55 , 0 , 0 , 0
   Data 48 , 44 , 50 , 53 , 54 , 56 , 27 , 0 , 211 , 43 , 51 , 45 , 42 , 57 , 0 , 0

   'shifted keys UPPER case  , Y und Z fr deutsche Tastatur
   Data 0 , 0 , 0 , 207 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
   Data 0 , 0 , 0 , 0 , 0 , 81 , 33 , 0 , 0 , 0 , 89 , 83 , 65 , 87 , 34 , 0
   Data 0 , 67 , 88 , 68 , 69 , 0 , 35 , 0 , 0 , 32 , 86 , 70 , 84 , 82 , 37 , 0
   Data 0 , 78 , 66 , 72 , 71 , 90 , 38 , 0 , 0 , 76 , 77 , 74 , 85 , 47 , 40 , 0
   Data 0 , 59 , 75 , 73 , 79 , 61 , 41 , 0 , 0 , 58 , 95 , 76 , 48 , 80 , 63 , 0
   Data 0 , 0 , 0 , 0 , 0 , 96 , 0 , 0 , 0 , 0 , 13 , 94 , 0 , 42 , 0 , 0
   Data 0 , 62 , 0 , 0 , 0 , 8 , 0 , 0 , 49 , 0 , 52 , 55 , 0 , 0 , 0 , 0
   Data 48 , 44 , 50 , 53 , 54 , 56 , 27 , 0 , 211 , 43 , 51 , 45 , 42 , 57 , 0 , 0

   '  Data 0 , F9 , 0 , F5 , F3 , F1 , F2 , F12 , 0 , F10 , F8 , F6 , F4 , 0 , &H5E , 0
   '  Data 0 , 0 , 0 , 0 , 0 , Q , 1 , 0 , 0 , 0 , Y , S , A , W , 2 , 0
   '  Data 0 , C , X , D , E , 4 , 3 , 0 , 0 , Space , v , f , t , r , 5, 0
   '  Data 0 , n , b , h , g , z , 6 , Bell , Backspace , Komma , m , j , u , 7 , 8 , 0
   '  Data 0 , vertical tab , k , i , o , 0 , 9 , 0 , 0 , Punkt , - , l , ; , p , + , 0
   '  Data 0 , 0 , 0 , 0 , 0 , \ , 0 , 0 , 0 , 0 , CR , 0 , 0 , \ , 0 , 0
   '  Data 0 , < , 0 , 0 , 0 , 0 , 8 , 0 , 0 , 1 , 0 , 4 , 7 , 0 , 0 , 0
   '  Data 0 , Komma , 2 , 5 , 6 , 8 , ESC , 0 , E , + , 3 , - , * , 9 , 0 , 0

   '****************************************************************************
   '41                 Data for Play Musik                                     *
   '****************************************************************************

Musik1:
   Data 4! , 523! , 4! , 587! , 4! , 659! , 4! , 523! , 4! , 587! , 8! , 659! , 4! , 494! , 8! , 587! , 12! , 523!